#ifndef _SHARED_DIRENT_H_
#define _SHARED_DIRENT_H_

/*******************************************************************************************
 * These two structure defines the informations returned to user by the opendir()
 * function, used by the readdir() function, and released by the closedir() function.
 * - "DIR" describes the complete directory.
 * - "dirent" describes one directory entry.
 ******************************************************************************************/

#define DIRENT_NAME_MAX_LENGTH  56
#define DIRENT_MAX_NUMBER       63

struct dirent
{
    unsigned int   inum;                                /*! inode identifier              */
    unsigned int   type;                                /*! inode type                    */
    char           name[DIRENT_NAME_MAX_LENGTH];        /*! directory entry name          */
};

typedef struct user_directory
{
    struct dirent   entry[DIRENT_MAX_NUMBER];
    unsigned int    current;
}
DIR;

#endif
