#ifndef _SHARED_WAIT_H_
#define _SHARED_WAIT_H_

/*********************************************************************************************
 * These macros can be used by the parent process to analyze a child process
 * termination status, as returned by the wait() syscall.
 * The termination state is a 32 bits word:
 * - the 8 LSB bits contain the user defined exit status
 * - the 24 other bits contain the flags defined below
 ********************************************************************************************/


#define PROCESS_TERM_STOP  0x100            /*! process received a SIGSTOP signal           */
#define PROCESS_TERM_KILL  0x200            /*! process killed by a SIGKILL signal          */
#define PROCESS_TERM_EXIT  0x400            /*! process terminated by a sys_exit()          */
#define PROCESS_TERM_WAIT  0x800            /*! parent process executed a sys_wait()        */

#define WIFEXITED( status )       (status & PROCESS_TERM_EXIT) 
#define WIFSIGNALED( status )     (status & PROCESS_TERM_KILL)
#define WIFSTOPPED( status )      (status & PROCESS_TERM_STOP)
#define WEXITSTATUS( status )     (status & 0xFF)

#define WNOHANG -1 // TODO Not in almos-mkh

#endif

