/*
 * hal_lapic.c - Local APIC
 *
 * Copyright (c) 2017 Maxime Villard
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_segmentation.h>
#include <hal_lapic.h>
#include <hal_internal.h>

#include <memcpy.h>
#include <thread.h>
#include <string.h>
#include <process.h>
#include <printk.h>
#include <vmm.h>
#include <core.h>
#include <cluster.h>

paddr_t lapic_pa __in_kdata = 0;
vaddr_t lapic_va __in_kdata = 0;

void lapic_write(uint32_t reg, uint32_t val)
{
	*((volatile uint32_t *)(lapic_va + reg)) = val;
}

uint32_t lapic_read(uint32_t reg)
{
	return *((volatile uint32_t *)(lapic_va + reg));
}

void hal_init_lapic()
{
	uint32_t id;

	lapic_va = hal_gpt_bootstrap_valloc(1); // XXX: should be shared

	hal_gpt_enter(lapic_va, lapic_pa);

	lapic_write(LAPIC_TPR, 0);
	lapic_write(LAPIC_SVR, LAPIC_SVR_ENABLE|LAPIC_SPURIOUS_VECTOR);

	id = lapic_read(LAPIC_ID) >> LAPIC_ID_SHIFT;

	x86_printf("-> LAPIC id: %d\n", id);
}

