/*
 * hal_kernel_types.h - Data types shared by kernel & libraries for TSAR-MIPS32.
 *
 * Author  Alain Greiner (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 *
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef HAL_SHARED_TYPES_H_
#define HAL_SHARED_TYPES_H_

/*******************i***************************************************************
 * This file defines - for the TSAR_MIPS32 architecture - the <reg_t> type, used 
 * by the hal_user_syscall() function, called by several user-level libraries 
 * to pass syscall arguments to the  kernel, and used by the do_syscall() function,
 * called by the kernel syscall handler, to analyse arguments.
 * It is also used by various kernel functions such as the hal_*_irq() functions
 * to save/restore the SR register value.
 **********************************************************************************/

#ifndef NULL
#define NULL    (void*)0
#endif

typedef unsigned long int     reg_t;    // core register

#endif	/* HAL_TYPES_H_ */
