///////////////////////////////////////////////////////////////////////////////////////
//  file   : display.c  
//  date   : may 2014
//  author : Alain Greiner
///////////////////////////////////////////////////////////////////////////////////////
//  This file describes the single thread "display" application.
//  It uses the external chained buffer DMA to display a stream
//  of images on the frame buffer.  
///////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <almosmkh.h>

#define FILENAME    "misc/images_128.raw"
#define FBF_TYPE    420         
#define NPIXELS     128
#define NLINES      128

/////////// Global variables  ///////////////////////////////////////

char    buffer[NPIXELS * NLINES] __attribute__((aligned(512)));

/////////////////////////
void build( char * base )
{
    int    line;
    int    pixel;
    char * buf;

    for( line = 0 ; line < NLINES ; line++ )
    {
        for( pixel = 0 ;  pixel < NPIXELS ; pixel++ )
        {
            buf = base + (line * NPIXELS) + pixel;

            *buf = ( ((pixel <  (NPIXELS>>1)) && (line <  (NLINES>>1))) ||
                     ((pixel >= (NPIXELS>>1)) && (line >= (NLINES>>1))) ) ? 0xFF : 0;
        }
    }
}

//////////////////////////////////////     
void print_block( unsigned int * buf )
{
    int offset;    // word index in array of words
    
    printf("\n***** content of buffer %x *****\n", buf );
    for( offset = 0 ; offset < 128 ; offset += 8 )
    {
        printf(" - %d\t: %x | %x | %x | %x | %x | %x | %x | %x\n",
        offset<<2, buf[offset+0], buf[offset+1], buf[offset+2], buf[offset+3], 
                   buf[offset+4], buf[offset+5], buf[offset+6], buf[offset+7] );
    }
}        
////////////////
int main( void )
{

    unsigned int    fbf_width;
    unsigned int    fbf_height;
    unsigned int    fbf_type;
    unsigned int    nbytes;
    unsigned int    image = 0;
    int             val;
    int             error;

    unsigned long long start_cycle;

    // get  start cycle
    get_cycle( &start_cycle );

    printf("\n[display] starts at cycle %d\n", (unsigned int)start_cycle );

    // check frame buffer size
    fbf_get_config( &fbf_width , &fbf_height , &fbf_type );

    if( (NPIXELS != fbf_width) || (NLINES != fbf_height) )
    {
        printf("\n[display error] FBF size [%d,%d] does not fit image size[%d,%d]\n",
        fbf_width, fbf_height, NPIXELS, NLINES );
        exit( 0 );
    }

    if( fbf_type != FBF_TYPE )
    {
        printf("\n[display error] FBF type [%d] does not fit image type [%d]\n",
        fbf_type, FBF_TYPE);
        exit( 0 );
    }

    // open file

    FILE * f = fopen( FILENAME , NULL );
//  int fd = open( FILENAME, O_RDONLY , 0 );

    if( f == NULL )
    {
        printf("\n[display error] Cannot open file <%s>\n", FILENAME );
        exit( 0 );
    }

    printf("\n[display] open file <%s>\n", FILENAME );

    // loop on images
    while ( 1 )
    {
        // load image from file
        nbytes = fread( buffer , 1 , NPIXELS * NLINES , f );
//      nbytes = read( fd , buffer , NPIXELS * NLINES );
        if( nbytes != NPIXELS * NLINES )
        {
            printf("\n[display error] Cannot load image %d\n", image );
            exit( 0 );
        }

        printf("\n[display] load image %d in buffer %x\n", image, buffer );
 
        // display image
        error = fbf_write( buffer , NPIXELS * NLINES , 0 );

        if( error )
        {
            printf("\n[display error] Cannot access frame buffer\n");
            exit( 0 );
        }

        printf("\n[display] display image %d\n", image );

        image++;

        // interactive behaviour
        val = getchar();
    }

    // close file
   fclose( f );
// close( fd );
   
    exit(0);

    return 0;
}
