/*
 * shared_socket.h - Shared mnemonics used by the socket related syscalls.
 *
 * Author  Alain Greiner (2016,2017,2018,2019,2020)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH.
 *
 * ALMOS-MKH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _SHARED_SOCKET_H_
#define _SHARED_SOCKET_H_

/******************************************************************************************* 
 * This defines the mnemonics for the domains (protocol families).
 ******************************************************************************************/

#define  AF_LOCAL       1    
#define  AF_INET        2

/******************************************************************************************* 
 * This defines the mnemonics for the socket types.
 ******************************************************************************************/

#define  SOCK_DGRAM     0
#define  SOCK_STREAM    1

/******************************************************************************************* 
 * This defines macros for endiannes handling.
 ******************************************************************************************/

/*
#define  HTONS( x )  (((x >> 8) & 0x00FF) + ((x << 8) & 0XFF00))

#define  HTONL( x )  (((x >> 24) & 0x000000FF) + \
                     ((x >> 8 ) & 0x0000FF00) + \
                     ((x << 8 ) & 0x00FF0000) + \
                     ((x << 24) & 0xFF000000))
*/

#define  HTONS( x )  (x) 

#define  HTONL( x )  (x) 

/******************************************************************************************* 
 * This enum defines the user operation mnemonics for socket access.
 ******************************************************************************************/

typedef enum
{
    SOCK_CREATE      = 0,      
    SOCK_BIND        = 1,
    SOCK_LISTEN      = 2,
    SOCK_CONNECT     = 3,
    SOCK_ACCEPT      = 4,
    SOCK_SEND        = 5,
    SOCK_RECV        = 6,
    SOCK_SENDTO      = 7,
    SOCK_RECVFROM    = 8,
}
socket_operation_type_t;

/***************************************************************************************** 
 * These structures define an user defined address in the communication space.
 * - sockaddr is the generic structure required by bind(), connect() & accept(),
 *   that supports various socket types.
 * _ sockaddr_in is the specific structure, used to build an IPv4 network address
 *   composed of an IP_address (32 bits) and a port_number (16 bits).
 ****************************************************************************************/

typedef struct sockaddr
{
    unsigned short     sa_domain;               // protocols family
    char               sa_data[14];             // address (format depends on sa_domain)
}
sockaddr_t;

typedef struct sockaddr_in
{
    unsigned short     sin_domain;              // AF_INET / AF_UNIX
    unsigned short     sin_port;                // port number
    unsigned long      sin_addr;                // IP address
}
sockaddr_in_t;


#endif // _SHARED_SOCKET_H_


