/*
 * hal_remote.c - implementation of Generic Remote Access API for TSAR-MIPS32
 * 
 * Authors : Mohammed Karaoui (2015)
 *           Alain Greiner    (2016)
 *
 * Copyright (c) UPMC Sorbonne Universites
 * 
 * This file is part of ALMOS-MKH..
 *
 * ALMOS-MKH. is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2.0 of the License.
 *
 * ALMOS-MKH. is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ALMOS-MKH.; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <hal_types.h>
#include <hal_internal.h>

void hal_remote_sb( xptr_t   xp,
                    uint8_t  data )
{
	x86_panic((char *)__func__);
}

void hal_remote_sw( xptr_t    xp,
                    uint32_t  data )
{
	x86_panic((char *)__func__);
}

void hal_remote_swd( xptr_t    xp,
                     uint64_t  data )
{
	x86_panic((char *)__func__);
}

void hal_remote_spt( xptr_t      xp,
                     void *      pt )
{
	x86_panic((char *)__func__);
}

char hal_remote_lb( xptr_t  xp )
{
	x86_panic((char *)__func__);
	return 0;
}

uint32_t hal_remote_lw( xptr_t  xp )
{
	x86_panic((char *)__func__);
	return 0;
}

uint64_t hal_remote_lwd( xptr_t  xp )
{
	x86_panic((char *)__func__);
	return 0;
}

void * hal_remote_lpt( xptr_t    xp,
                       void *    pt )
{
	x86_panic((char *)__func__);
	return NULL;
}

uint32_t hal_remote_lw_unc( xptr_t  xp )
{
	x86_panic((char *)__func__);
	return 0;
}

bool_t hal_remote_atomic_cas( xptr_t    xp,
                              uint32_t  old,
                              uint32_t  new )
{
	x86_panic((char *)__func__);
	return 0;
}

uint32_t hal_remote_atomic_add( xptr_t   xp, 
                                uint32_t incr )
{
	x86_panic((char *)__func__);
	return 0;
}

uint32_t hal_remote_atomic_and( xptr_t   xp, 
                                uint32_t mask )
{
	x86_panic((char *)__func__);
	return 0;
}

uint32_t hal_remote_atomic_or( xptr_t   xp, 
                               uint32_t mask )
{
	x86_panic((char *)__func__);
	return 0;
}

error_t hal_remote_atomic_try_add( xptr_t     xp,
                                   uint32_t   incr,
                                   uint32_t * old )
{
	x86_panic((char *)__func__);
	return 0;
}

void hal_remote_memcpy( xptr_t   dst,
                        xptr_t   src,
                        uint32_t size )
{
	x86_panic((char *)__func__);
}

