%{
#define COLOR_Milestone  "gtcMilestone"
#define COLOR_BOX_HEAVY "gtcBoxHeavy"
#define COLOR_BOX_LIGHT "gtcBoxLight"

#define PICT_TOPSEP   0.0
#define PICT_BOTSEP   3.0
#define PICT_LEFTSEP  3.0
#define PICT_RIGHTSEP 3.0
#define PICT_VSEP     2.0
#define PICT_HSEP     2.0

#define PICT_MONTHHEIGHT 5  // police height
#define PICT_MONTHWIDTH  (10./3.) 

#define TASK_VSEP  2
#define TASK_BGC0       "gtcTaskBG0"
#define TASK_BGC1       "gtcTaskBG1"
#define TASK_TITLEHEIGHT 6.
#define TASK_TITLEFONTHEIGHT 2.

#define DELIVRABLE_VSEP   1
#define DELIVRABLE_HEIGHT 3
#define DELIVRABLE_LABELWIDTH  10
#define DELIVRABLE_LABELHEIGHT DELIVRABLE_HEIGHT
#define DELIVRABLE_TITLEWIDTH  35
#define DELIVRABLE_TITLEHEIGHT DELIVRABLE_HEIGHT
#define DELIVRABLE_BOXHEIGHT   (DELIVRABLE_HEIGHT)

char* task_names[] = {
    0,
    "Project management",
    "Backbone infrastructure",
    "System generation",
    "HAS front-end",
    "HAS back-end",
    "PC/FPGA communication middleware",
    "Industrial demonstrators",
    "Dissemination",
    0
};
struct partner_def { char *key, *name, *fnfull, *fnshort; } partner_table[] = {
    { "UNKNOW" ,"relax"  ,0                       ,0                        },
    { "irisa"  ,"irisa"  ,"table_inria_cairn_full.tex"  ,"table_inria_cairn_short.tex"  },
    { "inria_compsys"    ,"inria_compsys"    ,"table_inria_compsys_full.tex"    ,"table_inria_compsys_short.tex"    },
    { "tima"   ,"tima"   ,"table_tima_full.tex"   ,"table_tima_short.tex"   },
    { "ubs"    ,"ubs"    ,"table_ubs_full.tex"    ,"table_ubs_short.tex"    },
    { "upmc"   ,"upmc"   ,"table_upmc_full.tex"   ,"table_upmc_short.tex"   },
    { "altera" ,"altera" ,"table_altera_full.tex" ,"table_altera_short.tex" },
    { "xilinx" ,"xilinx" ,"table_xilinx_full.tex" ,"table_xilinx_short.tex" },
    { "bull"   ,"bull"   ,"table_bull_full.tex"   ,"table_bull_short.tex"   },
    { "thales" ,"thales" ,"table_thales_full.tex" ,"table_thales_short.tex" },
    { "zied"   ,"zied"   ,"table_zied_full.tex"   ,"table_zied_short.tex"   },
    { "navtel" ,"navtel" ,"table_navtel_full.tex" ,"table_navtel_short.tex" },
    { 0        ,0        ,0                       ,0                        },
};

typedef struct _Tlivrable {
    int tn,stn,dn,vn;  // task, sub-task, number
    char v;            // 0, 1, 2, ..., F 
    char* title;
    int   bm,em;       // mois de bebut et de fin
    double hman[3];    // nombre de mh par an
    int    partner;    // index dans partner_table
    // these fields are filled by the program for data[tn][0][0][0]
    double task_y;           // top of task
    double task_dy;          // bot of task is task_y+task_dy
    double task_y_del;       // delivrables start at task_y+task_y_del
    double nbma[3];          // durée en mois par annee
    // these fields are filled by the program for data[tn][stn][dn][0]
    struct _Tlivrable
            **vers; // null termiated (vers[i] = &data[tn][stn][dn][i])
    int    nbvers;     // nombre de vers
    double height;     // height of livrable
    // int del_bm,del_em;    // mois de bebut et de fin cummule
    // these fields are filled by the program for all elements
    int   nbTitleLines;
    char* titleLines[5]; // null termiated
} Tlivrable;

#define T_MAX 10
#define S_MAX 10
#define D_MAX 10
#define V_MAX 10
typedef struct _Tdata {
    FILE*      os;
    Tlivrable* ls[T_MAX][S_MAX][D_MAX][V_MAX];
} Tdata;
Tdata  data_org;
Tdata* curr;

Tdata* data_new(int *tnplus, int *tnmoins)
{
    int i,skip;
    int tn,stn,dn,v;
    Tdata* data = malloc(sizeof(*data));
    memset(data,0,sizeof(*data));
    for (tn=0 ; tn<T_MAX ; tn++)
    for (stn=0; stn<S_MAX; stn++)
    for (dn=0; dn<D_MAX; dn++)
    for (v=0; v<V_MAX; v++) {
        if ( data_org.ls[tn][stn][dn][v]==0 ) continue;
        // tnplus treatment
        skip = 0;
        if (tnplus!=0) {
            skip=1;
            for (i=0 ; tnplus[i]!=-1 ; i++) {
                if ( tnplus[i]==data_org.ls[tn][stn][dn][v]->tn ) {
                    skip=0;
                    break;
        }   }   }
        if (skip) continue;
        // tnmoins treatment
        skip = 0;
        if (tnmoins!=0) {
            for (i=0 ; tnmoins[i]!=-1 ; i++) {
//fprintf(stderr,"i=%d data_org.ls[tn][stn][dn][v]->tn=%d tnmoins[i]=%d\n",i,data_org.ls[tn][stn][dn][v]->tn,tnmoins[i]);
                if ( tnmoins[i]==data_org.ls[tn][stn][dn][v]->tn ) {
                    skip=1;
                    break;
        }   }   }
//fprintf(stderr,"selected: [tn][stn][dn][v]=%d,%d,%d,%d skip=%d\n",tn,stn,dn,v,skip);
        if (skip) continue;
        Tlivrable* l=malloc(sizeof(*l));
        *l = *data_org.ls[tn][stn][dn][v];
        data->ls[tn][stn][dn][v] = l;
//fprintf(stderr,"selected: [tn][stn][dn][v]=%d,%d,%d,%d\n",tn,stn,dn,v);
    }
    return data;
}

int milestones[100];

char* gen_label_base(char* buf,Tlivrable*p)
    { if (p->dn >=0) sprintf(buf,"D%d%d%d",p->tn,p->stn,p->dn); else sprintf(buf,""); return buf; }
char* gen_label_vers(char* buf,Tlivrable*p)
    { if (p->nbvers<=1) strcpy(buf,""); else sprintf(buf,"V%c",p->v); return buf; }
char* gen_label_full(char* buf,Tlivrable*p)
    { char b[100],v[100]; gen_label_base(b,p); gen_label_vers(v,p);
      sprintf(buf,"%s%s%s",b,*v?"-":"",v); return buf; }

void print_put(double x,double y, const char* object)
    { fprintf(curr->os,"\\put(%.2f,%.2f){%s}\n",x,y,object); }
void print_hline(double x,double y, double len, const char* color)
{
    char object[1024];
    if (color!=0) { fprintf(curr->os,"\\bgroup\\color{%s}\n",color); }
    sprintf(object,"\\line(1,0){%.2f}",len);
    print_put(x,y,object);
    if (color!=0) { fprintf(curr->os,"\\egroup\n"); }
}
void print_vline(double x,double y, double len, const char* color)
{
    char object[1024];
    if (color!=0) { fprintf(curr->os,"\\bgroup\\color{%s}\n",color); }
    sprintf(object,"\\line(0,1){%.2f}",len);
    print_put(x,y,object);
    if (color!=0) { fprintf(curr->os,"\\egroup\n"); }
}
void print_box(
    int filled, char* vers, // vers may be 0,
    double x,double y, double dx, double dy,
    const char* boxcolor,  // may be 0 (default COLOR_BOX_HEAVY)
    const char* bgcolor,   // may be 0 (not set)
    const char* textcolor //  may be 0 (black)
){
    double tn=.4;
    char object[1024];
    if ( boxcolor==0 ) boxcolor = COLOR_BOX_HEAVY;
    if ( filled==1 ) {
        sprintf(object,
            "\\fcolorbox{black}{%s}{\\makebox(%.2f,%.2f){}}",
                boxcolor,dx-2-tn,dy-2-tn);
        print_put(x,y+1,object);
    } else {
        double tn2=tn/2;
        double e=.1;
        fprintf(curr->os,"\\bgroup\\color{%s}\n",boxcolor);
        fprintf(curr->os,"\\linethickness{%.2fmm}\n",tn);
        print_hline(x+tn2-e ,y,    dx     ,0);
        print_hline(x+tn2-e ,y+dy, dx     ,0);
        print_vline(x+tn-e  ,y+e,  dy-2*e ,0);
        print_vline(x+dx-2*e,y+e,  dy-2*e ,0);
        fprintf(curr->os,"\\egroup\n");
    }
    if (vers) {
        sprintf(object,"\\begin{tiny}\\textbf{%s}\\end{tiny}",vers);
        print_put(x+1,y+.5,object);
    }
}

void gen_titleLines(Tlivrable*p)
{
    const char* macro="\\ganttlf";
    char* pc = p->title;
    char* pc2;

    if (pc==0) return;
    
    while ( (pc2=strstr(pc,macro))!=0 ) {
        char c = *pc2;
        *pc2 = 0;
        p->titleLines[p->nbTitleLines]=strdup(pc);
        p->nbTitleLines+=1;
        *pc2=c;
        pc=pc2+strlen(macro);
    }
    p->titleLines[p->nbTitleLines]=strdup(pc);
    p->nbTitleLines+=1;
}
%}

%option noyywrap

%%
 int tn,stn,dn,v,bm,em; char* title;
 double an[3];
 char*  an_comment;
 int    partner;
#.*\n   ;
T=[0-9]+  { tn=atoi(yytext+2); }
S=[0-9]+  { stn=atoi(yytext+2); }
D=[0-9]+  { dn=atoi(yytext+2); }
D=none    { dn=-2; }
V=V[1-8F] { v=yytext[3]; }
ML=[0-9]+ {
        int i;
        for (i=0 ; milestones[i]!=0 ; i++);
        milestones[i] = atoi(yytext+3);
    }
BM=[0-9]+ { bm=atoi(yytext+3); }
EM=[0-9]+ { em=atoi(yytext+3); }
R=none    { an[0]=0; an[1]=0; an[2]=0; an_comment=0; }
R=[0-9:.]+ {
        char tmp[1000];
        int status = sscanf(yytext+2,"%lf:%lf:%lf:%s",an+0,an+1,an+2,tmp);
        if (status<3) {
            fprintf(stderr,"%s: is not resource definition, expected format \"N:N:N\" (near D%d%d%d-V%c)\n",
               yytext+2,tn,stn,dn,v);
            an[0]=0; an[1]=0; an[2]=0; an_comment=0;
        } else if (status==3) {
            an_comment = 0;
        } else
            an_comment = strdup(tmp);
    }
PART="{"[^}]+"}"  {
        int i;
        partner=-1;
        for (i=0; partner_table[i].key!=0 ; i++) {
            if (strstr(yytext,partner_table[i].key)!=0 ) {
                partner=i;
                break;
            }
        }
        if ( partner==-1 ) {
            fprintf(stderr,"%s: does not contains a partner key (near D%d%d%d-V%c)\n",
               yytext+5,tn,stn,dn,v);
            partner=0;
        }
    }
TITLE=.*\n {
        char* pc=yytext+6;
        yytext[yyleng-1]=0;
        while ( *pc==' ' || *pc=='\t' ) pc+=1;
        title=strdup(pc);
        Tlivrable* p= (Tlivrable*) calloc(sizeof(*p),1);
        p->tn = tn;
        p->stn = stn;
        p->dn = dn;
        p->v  = v;
        p->hman[0] = an[0];
        p->hman[1] = an[1];
        p->hman[2] = an[2];
        p->partner = partner;
        p->title = title;
        p->bm = bm;
        p->em = em;
        gen_titleLines(p);

        for (v=0; data_org.ls[tn][stn][dn][v]!=0 ; v++);
        data_org.ls[tn][stn][dn][v] = p;
//fprintf(stderr,"ADDED: %d %d %d %d\n",tn,stn,dn,v);
    }
[ \t\n] ;
.   { fprintf(stderr,"%c: unexpected value in anr.gantt file (near D%d%d%d-V%c)\n",
        *yytext,tn,stn,dn,v); }
%%

void prepare0(Tdata* data)
{
int tn,stn,v;
int i0,i1,i;
    for (tn=0 ; tn<T_MAX ; tn++)
    for (stn=0; stn<S_MAX; stn++) {
//fprintf(stderr,"AVANT:t=%d:%d:: ",tn,stn); for (i=0; i<D_MAX ; i++)
//fprintf(stderr,"%d:%p ",i,data->ls[tn][stn][i][0]); fprintf(stderr,"\n");
        while (1) {
            for (i0=0 ; i0<D_MAX ; i0++)
                if (data->ls[tn][stn][i0][0] == 0) break;
            for (i1=i0+1 ; i1<D_MAX ; i1++)
                if (data->ls[tn][stn][i1][0] != 0) break;
            if (i1>=D_MAX) break;
            // shift 
            for (i=0 ; (i1+i)<D_MAX ; i++)
                for (v=0;v<V_MAX;v+=1) {
                    data->ls[tn][stn][i0+i][v] = data->ls[tn][stn][i1+i][v];
                    data->ls[tn][stn][i1+i][v] = 0;
                }
        }
//fprintf(stderr,"AVANT:t=%d:%d:: ",tn,stn); for (i=0; i<D_MAX ; i++)
//fprintf(stderr,"%d:%p ",i,data->ls[tn][stn][i][0]); fprintf(stderr,"\n");
    }
}
void prepare1(Tdata* data)
{
int tn,dn,v;
int i0,i1,i;
    for (tn=0 ; tn<T_MAX ; tn++) {
//fprintf(stderr,"AVANT:t=%d:: ",tn,i0,i1); for (i=0; i<S_MAX ; i++) fprintf(stderr,"%d:%p ",i,data->ls[tn][i][0][0]); fprintf(stderr,"\n");
        while (1) {
            for (i0=0 ; i0<S_MAX ; i0++)
                if (data->ls[tn][i0][0][0] == 0) break;
            for (i1=i0+1 ; i1<S_MAX ; i1++)
                if (data->ls[tn][i1][0][0] != 0) break;
//fprintf(stderr,"%d %d %d\n",tn,i0,i1);
            if (i1>=S_MAX) break;
            // shift 
            for (i=0 ; (i1+i)<S_MAX ; i++)
                for (dn=0;dn<D_MAX;dn+=1) 
                    for (v=0;v<V_MAX;v+=1) {
                        data->ls[tn][i0+i][dn][v] = data->ls[tn][i1+i][dn][v];
                        data->ls[tn][i1+i][dn][v] = 0;
                    }
        }
//fprintf(stderr,"APRES:t=%d:: ",tn,i0,i1); for (i=0; i<S_MAX ; i++) fprintf(stderr,"%d:%p ",i,data->ls[tn][i][0][0]); fprintf(stderr,"\n");
    }
}
void prepare2(Tdata* data)
{
int tn0,tn1,stn,dn,vn;
int moved=1;
    while (moved) {
        moved=0;
        for (tn0=0 ; tn0<T_MAX ; tn0++)
            if (data->ls[tn0][0][0][0] == 0) break;
        for (tn1=tn0+1 ; tn1<T_MAX ; tn1++)
            if (data->ls[tn1][0][0][0] != 0) break;
        if (tn1==T_MAX) break;
        for (stn=0 ; stn<S_MAX ; stn++)
            for (dn=0;dn<D_MAX;dn+=1) 
                for (vn=0;vn<V_MAX;vn+=1) {
                    data->ls[tn0][stn][dn][vn] = data->ls[tn1][stn][dn][vn];
                    data->ls[tn1][stn][dn][vn] = 0;
                }
        moved=1;
    }
}

void prepare3(Tdata* data)
{
int tn,stn,dn,vn;
    for (tn=0 ; tn<T_MAX ; tn++)
    for (stn=0; stn<S_MAX; stn++)
    for (dn=0; dn<D_MAX; dn++) {
        Tlivrable* p = data->ls[tn][stn][dn][0];
        if (p==0) continue;
        p->nbvers=0 ;
        for (vn=0 ; vn<V_MAX ; vn+=1) 
            if (data->ls[tn][stn][dn][vn]!=0) p->nbvers+=1;
        p->vers=(Tlivrable**)malloc(sizeof(*p->vers)*(p->nbvers+1));
        for (vn=0 ; vn<p->nbvers ; vn+=1) {
            p->vers[vn] = data->ls[tn][stn][dn][vn];
            data->ls[tn][stn][dn][vn]->nbvers = p->nbvers;
        }
        p->vers[vn] = 0;
        p->height = 1.0*DELIVRABLE_HEIGHT;
        if (p->nbTitleLines>=1) {
            double h=0;
            h += p->vers[p->nbvers-1]->nbTitleLines*DELIVRABLE_TITLEHEIGHT;
            h += (p->vers[p->nbvers-1]->nbTitleLines-1)*(DELIVRABLE_TITLEHEIGHT/5.);
            if ( h>p->height) p->height=h;
        }
        Tlivrable* lu= p->vers[p->nbvers-1];
        int i;
fprintf(stderr,"--------------------\n");
        for (i=0 ; i<p->nbvers ; i++) {
            Tlivrable* l= p->vers[i];
            double bm= l->bm;
            double em= l->em;
//fprintf(stderr,"  %d%d%d-V%c: bm=%2.f em=%2.f --> %2.1f %2.1f %2.1f\n",l->tn,l->stn,l->dn,l->v,bm,em, lu->nbma[0],lu->nbma[1],lu->nbma[2]);
            if (bm<12 && em>0) {
                lu->nbma[0] += (em>12?12:em)-bm;
                bm=12;
            }
            if (bm<24 && em>12) {
                lu->nbma[1] += (em>24?24:em)-bm;
                bm=24;
            }
            if (bm<36 && em>24) {
                lu->nbma[2] += em-bm;
            }
//fprintf(stderr,"  %d%d%d-V%c: bm=%2.f em=%2.f --> %2.1f %2.1f %2.1f %p\n",l->tn,l->stn,l->dn,l->v,bm,em, lu->nbma[0],lu->nbma[1],lu->nbma[2], lu);
        }
    }
}

double task_livrable_height(int tn, double* delivrable_y)
{
int    stn,dn,nblivrables=0;
double height=0;
    height += TASK_TITLEHEIGHT ;
    *delivrable_y = height;
    for (stn=0 ; curr->ls[tn][stn][0][0]!=0 ; stn++)
        for (dn=0 ; curr->ls[tn][stn][dn][0]!=0 ; dn++) {
            nblivrables += 1;
            height+=curr->ls[tn][stn][dn][0]->height;
        }
        height += DELIVRABLE_VSEP/2;
        height += (nblivrables-1)*DELIVRABLE_VSEP;
        height += DELIVRABLE_VSEP/2;
    return height;
}

void  task_box(double pictwidth)
{
    int tn;
    for ( tn=0 ; curr->ls[tn][0][0][0]!=0 ; tn++ ) {
        const char* color= (tn%2)!=0 ? TASK_BGC1 : TASK_BGC0 ;
        fprintf(curr->os,
            "\\put(%.2f,%.2f){\\fcolorbox{black}{%s}{\\makebox(%5.2f,%5.2f){}}}\n",
            0.0,curr->ls[tn][0][0][0]->task_y,
            color,
            pictwidth,curr->ls[tn][0][0][0]->task_dy
        );
    }
}

void  month_grid(double x, double y, double dx, double dy)
{
    int i;
    for (i=0 ;  i<=36 ; i+=1,x+=PICT_MONTHWIDTH) {
        if ( (i%3)!=0 ) continue;
        fprintf(curr->os,
            "\\put(%5.1f,%5.1f){\\line(0,1){%5.1f}}\\put(%5.1f,%5.1f){%d}\n",
            x,y,dy-PICT_MONTHWIDTH-PICT_VSEP,
            x-2,y+dy-PICT_MONTHHEIGHT,
            i
        );
    }
}

void  print_milestones(double x, double y, double dx, double dy)
{
    int i;
    double tn=.3;
    //x=x-tn/2;
    fprintf(curr->os,"\\bgroup\n");
    fprintf(curr->os,"\\color{red}\n");
    fprintf(curr->os,"\\linethickness{%.2fmm}\n",tn);
    for (i=0 ;  milestones[i]!=0 ; i+=1) {
        double xx= x + milestones[i]*PICT_MONTHWIDTH;
        print_vline(xx,y,dy-PICT_MONTHWIDTH-PICT_VSEP,0);
    }
    fprintf(curr->os,"\\egroup\n");
}

double delivrable(
    double label_x, double box_x, double title_x,
    double y,
    int tn, int stn, int dn)
{
    Tlivrable* top=curr->ls[tn][stn][dn][0];
    Tlivrable* last=curr->ls[tn][stn][dn][top->nbvers-1];
    char tmp[1000],label[1000],title[1000];
    double y0;
    int v;
    double label_dx = DELIVRABLE_LABELWIDTH ;
    double label_dy = DELIVRABLE_LABELHEIGHT ;
    double boxx,box_dx;
    double box_dy = DELIVRABLE_BOXHEIGHT ;
    double title_dx = DELIVRABLE_LABELWIDTH ;
    double title_dy = DELIVRABLE_TITLEHEIGHT ;
    
//print_hline(0,y,180,0);
    gen_label_base(label,top);
    // y -= DELIVRABLE_HEIGHT;
    y -= top->height ;
//print_hline(0,y,180,0);
    fprintf(curr->os,"%% Delivrable %s (tn=%d stn=%d dn=%d\n",label,tn,stn,dn);

    // print label
    //y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_LABELHEIGHT)/2;
    y0 = (top->height-DELIVRABLE_LABELHEIGHT)/2;
    sprintf(tmp,"\\ganttlabelstyle{%s}",label);
    print_put(label_x,y+y0,tmp);
    // print title
    if (last->nbTitleLines==1) {
        y0  = (DELIVRABLE_HEIGHT-DELIVRABLE_TITLEHEIGHT)/2;
        y0 += DELIVRABLE_TITLEHEIGHT/5. ;
        sprintf(tmp,"\\gantttitlestyle{%s}",last->title);
        print_put(title_x,y+y0,tmp);
    } else if (last->nbTitleLines>1) {
        int i;
        // y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_TITLEHEIGHT)/2;
        y0=DELIVRABLE_TITLEHEIGHT/5.;
        sprintf(tmp,"\\gantttitlestyle{\\shortstack[l]{%s",last->titleLines[0]);
        for (i=1 ; i<last->nbTitleLines ; i+=1) {
            strcat(tmp,"\\\\");
            strcat(tmp,last->titleLines[i]);
        }
        strcat(tmp,"}}");
        print_put(title_x,y+y0,tmp);
    }
        
    // print box
    //y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_BOXHEIGHT)/2;
    y0 = (top->height-DELIVRABLE_BOXHEIGHT)/2;
    if ( last==top ) {
        Tlivrable* l=top;
        boxx = box_x + l->bm*PICT_MONTHWIDTH ;
        box_dx  = (l->em - l->bm) * PICT_MONTHWIDTH;
        print_box(1,0,boxx,y+y0,box_dx,box_dy,COLOR_BOX_LIGHT,0,0);
        print_box(0,0,boxx,y+y0,box_dx,box_dy,0,0,0);
    } else for (v=0 ; v<top->nbvers ; v+=1) {
        Tlivrable* l=curr->ls[tn][stn][dn][v] ;
        gen_label_vers(tmp,l);
        boxx = box_x + l->bm*PICT_MONTHWIDTH ;
        box_dx  = (l->em - l->bm) * PICT_MONTHWIDTH;
        print_box(1,0,boxx,y+y0,box_dx,box_dy,COLOR_BOX_LIGHT,0,0);
        print_box(0,tmp,boxx,y+y0,box_dx,box_dy,0,0,0);
    }
    y -= DELIVRABLE_VSEP;
    return y;
}

void task_delivrable(double label_x, double box_x, double title_x, int tn)
{
int stn,dn;
Tlivrable* task=curr->ls[tn][0][0][0];
double y = task->task_y+task->task_dy-task->task_y_del;
    char tmp[1000];
    sprintf(tmp,"\\textbf{Task-%d \\textit{%s}}",task->tn,task_names[task->tn]);
    print_put(label_x/2,y+(TASK_TITLEHEIGHT-TASK_TITLEFONTHEIGHT)/2,tmp);

    //y += DELIVRABLE_VSEP/2. ;
    for (stn=0 ; curr->ls[tn][stn][0][0]!=0 ; stn++)
        for (dn=0 ; curr->ls[tn][stn][dn][0]!=0 ; dn++) {
			if (curr->ls[tn][stn][dn][0]->dn >=0)
				y=delivrable(label_x,box_x,title_x,y,tn,stn,dn);
        }
}

void do_gantt(const char* fn, int* tnplus, int* tnmoins)
{
    int tn;
    double pictwidth, pictheight;
    double gantt_x,gantt_y;
    double gantt_dx,gantt_dy;

    double label_x,title_x;
    curr = data_new(tnplus,tnmoins);
    if ( (curr->os=fopen(fn,"w"))==0 ) {
        fprintf(stderr,"can not open %s file for writing.\n",fn);
        fprintf(stderr,"generation of %s graph is skipped.\n",fn);
        return;
    }
    prepare0(curr);
    prepare1(curr);
    prepare2(curr);
    prepare3(curr);

    pictheight=0 ;
    pictheight += PICT_BOTSEP ;
    for ( tn=0 ; curr->ls[tn][0][0][0]!=0 ; tn++ );
    for ( tn=tn-1 ; tn>=0 ; tn-- ) {
        double offset;
        curr->ls[tn][0][0][0]->task_y     = pictheight;
        curr->ls[tn][0][0][0]->task_dy    = task_livrable_height(tn,&offset);
        curr->ls[tn][0][0][0]->task_y_del = offset;
        pictheight += curr->ls[tn][0][0][0]->task_dy;
        pictheight += TASK_VSEP;
    }
    pictheight += PICT_MONTHHEIGHT;
    pictheight += PICT_TOPSEP ;
    gantt_y  = PICT_BOTSEP ;
    gantt_dy = pictheight-PICT_TOPSEP-PICT_BOTSEP ;

    pictwidth=0;
    pictwidth += PICT_LEFTSEP;
    label_x    = pictwidth;
    pictwidth += DELIVRABLE_LABELWIDTH;
    pictwidth += PICT_HSEP;
    gantt_x    = pictwidth ;
    gantt_dx   = 36*PICT_MONTHWIDTH ;
    pictwidth += gantt_dx ;
    pictwidth += PICT_HSEP;
    title_x    = pictwidth;
    pictwidth += DELIVRABLE_TITLEWIDTH;
    pictwidth += PICT_RIGHTSEP;
    
    fprintf(curr->os,"\\setlength{\\unitlength}{1.0mm}\n");
    fprintf(curr->os,"\\begin{picture}(%.1f,%.1f)\n",pictwidth,pictheight);
    //print_hline(0,0,pictwidth,0);
    //print_hline(0,pictheight,pictwidth,0);
    task_box(pictwidth);
    month_grid(gantt_x,gantt_y,gantt_dx,gantt_dy);
    for ( tn=0 ; curr->ls[tn][0][0][0]!=0 ; tn++ ) {
        task_delivrable(label_x,gantt_x,title_x,tn);
    }

    print_milestones(gantt_x,0,gantt_dx,gantt_dy+gantt_y);
    fprintf(curr->os,"\\end{picture}\n");
    fclose(curr->os);
    curr->os=0;
}

void do_partner_table_full(int partner)
{
    struct partner_def* part = partner_table+partner;
    if ( (curr->os=fopen(part->fnfull,"w"))==0 ) {
        fprintf(stderr,"can not open %s file for writing.\n",part->fnfull);
        fprintf(stderr,"generation of %s partner table is skipped.\n",part->fnfull);
        return;
    }
    fprintf(curr->os,"\\begin{tabular}{|c|l||r|r|r||r|}\\hline\n");
    fprintf(curr->os,
        "number & \\multicolumn{1}{c||}{title} & \\multicolumn{3}{c||}{years } & total \\\\\\cline{3-5}\n");
    fprintf(curr->os,
        " & & \\multicolumn{1}{c|}{1} & \\multicolumn{1}{c|}{2} & "
        "\\multicolumn{1}{c||}{3} &  \\\\\\hline\\hline\n");
    int tn,stn,dn,v=0;
    double an1=0,an2=0,an3=0,an=0;
    double tsk1,tsk2,tsk3,tsk;
    int newlineadded=1;
    for (tn=0 ; tn<T_MAX ; tn++) {
        if (curr->ls[tn][0][0][0]==0) break;
        if (tn!=0 && newlineadded==0 ) {
            newlineadded = 1;
            fprintf(curr->os,"\\hline ");
        }
		tsk1=tsk2=tsk3=tsk=0;
        for (stn=0; stn<S_MAX; stn++) {
            for (dn=0; dn<D_MAX; dn++) {
                Tlivrable* top=curr->ls[tn][stn][dn][v];
                if (top==0) continue;
                Tlivrable* last=top->vers[top->nbvers-1];
                if (last->partner!=partner) continue;
                double sum1,sum2,sum3,sum=0;
                sum1 = last->hman[0]; sum +=sum1;
                sum2 = last->hman[1]; sum +=sum2;
                sum3 = last->hman[2]; sum +=sum3;
                char label[1000],title[1000];
                gen_label_base(label,last);
                sprintf(title,"\\resstablestyletitle{%s}",last->title);
                fprintf(curr->os,"%s & %s & %2.1f & %2.1f & %2.1f & %2.1f \\\\\\hline\n",
                   label,title,sum1,sum2,sum3,sum);
                an1 += sum1 ; tsk1 += sum1 ;
                an2 += sum2 ; tsk2 += sum2 ;
                an3 += sum3 ; tsk3 += sum3 ;
                an  += sum  ; tsk  += sum  ;
                newlineadded=0;
                if ( sum1==0 && last->nbma[0]!=0) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 1 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum1,last->nbma[0]);
                else if (sum1!=0 && last->nbma[0]==0 ) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 1 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum1,last->nbma[0]);
                else if (sum1!=0 && sum1>last->nbma[0] ) 
                    fprintf(stderr,"WARNING: %-10s:%s probleme sur l'an 1 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum1,last->nbma[0]);
                if ( sum2==0 && last->nbma[1]!=0) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 2 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum2,last->nbma[1]);
                else if ( sum2!=0 && last->nbma[1]==0) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 2 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum2,last->nbma[1]);
                else if (sum2!=0 && sum2>last->nbma[1]) 
                    fprintf(stderr,"WARNING: %-10s:%s probleme sur l'an 2 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum2,last->nbma[1]);
                if ( sum3==0 && last->nbma[2]!=0) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 3 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum3,last->nbma[2]);
                else if ( sum3!=0 && last->nbma[2]==0) 
                    fprintf(stderr,"ERROR:   %-10s:%s probleme sur l'an 3 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum3,last->nbma[2]);
                else if (sum3!=0 && sum3>last->nbma[2]) 
                    fprintf(stderr,"WARNING: %-10s:%s probleme sur l'an 3 (in table=%2.1f, in gantt=%2.1f\n",
                        part->name,label,sum3,last->nbma[2]);
            }
        }
		if (tsk!=0)
    	fprintf(curr->os,"%s & total Task-%d & %2.1f & %2.1f & %2.1f & %2.1f \\\\\\hline\n",
            "",curr->ls[tn][0][0][0]->tn,tsk1,tsk2,tsk3,tsk);
		
    }
    if ( an!=(an1+an2+an3) ) {
        fprintf(stderr,"bad computation in %s table.\n",part->fnfull);
    }
    fprintf(curr->os,"\\hline\n");
    fprintf(curr->os,"%s & %s & %2.1f & %2.1f & %2.1f & %2.1f \\\\\\hline\n",
            "","total",an1,an2,an3,an);

    fprintf(curr->os,"\\end{tabular}\n");
    fclose(curr->os);
    curr->os=0;
}

void do_partner_table_short(int partner)
{
    struct partner_def* part = partner_table+partner;
    if ( (curr->os=fopen(part->fnshort,"w"))==0 ) {
        fprintf(stderr,"can not open %s file for writing.\n",part->fnshort);
        fprintf(stderr,"generation of %s partner table is skipped.\n",part->fnshort);
        return;
    }
    fprintf(curr->os,"\\begin{center}\\begin{small}\\begin{tabular}{|c|l||r|r|r||r|}\\hline\n");
    fprintf(curr->os,
        " & title & \\multicolumn{3}{c||}{years } & total \\\\\\cline{3-5}\n");
    fprintf(curr->os,
        " &       & \\multicolumn{1}{c|}{1} & \\multicolumn{1}{c|}{2} & "
                    "\\multicolumn{1}{c||}{3} &  \\\\\\hline\\hline\n");
    int tn,stn,dn,v=0;
    double an1=0,an2=0,an3=0,an=0;
    double tsk1,tsk2,tsk3,tsk;
    int newlineadded=1;
    for (tn=0 ; tn<T_MAX ; tn++) {
        if (curr->ls[tn][0][0][0]==0) break;
		tsk1=tsk2=tsk3=tsk=0;
        for (stn=0; stn<S_MAX; stn++) {
            for (dn=0; dn<D_MAX; dn++) {
                Tlivrable* top=curr->ls[tn][stn][dn][v];
                if (top==0) continue;
                Tlivrable* last=top->vers[top->nbvers-1];
                if (last->partner!=partner) continue;
                double sum1,sum2,sum3,sum=0;
                sum1 = last->hman[0]; sum +=sum1;
                sum2 = last->hman[1]; sum +=sum2;
                sum3 = last->hman[2]; sum +=sum3;
                an1 += sum1 ; tsk1 += sum1 ;
                an2 += sum2 ; tsk2 += sum2 ;
                an3 += sum3 ; tsk3 += sum3 ;
                an  += sum  ; tsk  += sum  ;
                newlineadded=0;
                char label[1000];
                gen_label_base(label,last);
            }
        }
		if (tsk!=0)
    	fprintf(curr->os,"Task-%d & %s & %2.1f & %2.1f & %2.1f & %2.1f \\\\\\hline\n",
            curr->ls[tn][0][0][0]->tn,
            task_names[curr->ls[tn][0][0][0]->tn],tsk1,tsk2,tsk3,tsk);
		
    }
    if ( an!=(an1+an2+an3) ) {
        fprintf(stderr,"bad computation in %s table.\n",part->fnshort);
    }
    fprintf(curr->os,"\\hline\n");
    fprintf(curr->os," & %s &  %2.1f & %2.1f & %2.1f & %2.1f \\\\\\hline\n",
            "total",an1,an2,an3,an);

    fprintf(curr->os,"\\end{tabular}\\end{small}\\end{center}\n");
    fclose(curr->os);
    curr->os=0;
}

int main()
{
    int tnplus[10] = { 1, 2, 3, 4, -1 };
    int tnmoins[10] = { 1, 2, 3, 4, -1 };

    yylex();
    do_gantt("gantt.tex",0,0);
    do_gantt("gantt1.tex",tnplus,0);
    do_gantt("gantt2.tex",0,tnmoins);

    curr = data_new(0,0);
    prepare0(curr);
    prepare1(curr);
    prepare2(curr);
    prepare3(curr);
    do_partner_table_full(1); do_partner_table_short(1);
    do_partner_table_full(3); do_partner_table_short(3);
    do_partner_table_full(4); do_partner_table_short(4);
    do_partner_table_full(5); do_partner_table_short(5);
    do_partner_table_full(7); do_partner_table_short(7);
    do_partner_table_full(8); do_partner_table_short(8);
    do_partner_table_full(9); do_partner_table_short(9);
    do_partner_table_full(10); do_partner_table_short(10);
    do_partner_table_full(11); do_partner_table_short(10);

    return 0;
}
