%{

#define PICT_TOPSEP   3
#define PICT_BOTSEP   3
#define PICT_LEFTSEP  3
#define PICT_RIGHTSEP 3
#define PICT_VSEP     2
#define PICT_HSEP     2

#define PICT_MONTHHEIGHT 5  // police height
#define PICT_MONTHWIDTH  (10./3.) 

#define TASK_VSEP  2
#define TASK_BGC0 "red"
#define TASK_BGC1 "yellow"

#define DELIVRABLE_VSEP   1
#define DELIVRABLE_HEIGHT 3
#define DELIVRABLE_LABELWIDTH  15
#define DELIVRABLE_LABELHEIGHT DELIVRABLE_HEIGHT
#define DELIVRABLE_TITLEWIDTH  25
#define DELIVRABLE_TITLEHEIGHT DELIVRABLE_HEIGHT
#define DELIVRABLE_BOXHEIGHT   (DELIVRABLE_HEIGHT-2)

typedef struct _Tlivrable {
    int tn,stn,dn;  // task, sub-task, number
    char v;         // 0, 1, 2, ..., F 
    char* title;
    int   bm,em;   // mois de bebut et de fin
    // this fields are filled by the program for data[tn][0][0][0]
    int    task_line;
    double task_y;           // top of task
    double task_dy;          // bot of task is task_y+task_dy
    // this fields are filled by the program for data[tn][stn][dn][0]
    int   del_bm,del_em;    // mois de bebut et de fin cummule
} Tlivrable;

#define T_MAX 10
#define S_MAX 10
#define D_MAX 10
#define V_MAX 10
Tlivrable* data[T_MAX][S_MAX][D_MAX][V_MAX];
%}

%option noyywrap

%%
 int tn,stn,dn,v,bm,em; char* title;
#.*\n   ;
T=[0-9]+ { tn=atoi(yytext+2); }
T=D[0-9]+ { tn=atoi(yytext+3); }
S=[0-9]+ { stn=atoi(yytext+2); }
D=[0-9]+ { dn=atoi(yytext+2); }
V=V.     { v=yytext[3]; }
DV=-VF   { dn=0; v='F'; }
DV=      { dn=0; v='F'; }
DV=-[0-9]-VF     { dn=yytext[4]-'0'; v=yytext[yyleng-1]; }
DV=-[0-9]-V[0-9] { dn=yytext[4]-'0'; v=yytext[yyleng-1]; }

BM=[0-9]+ { bm=atoi(yytext+3); }
EM=[0-9]+ { em=atoi(yytext+3); }
TITLE=.*\n {
        char* pc=yytext+6;
        while ( *pc==' ' || *pc=='\t' ) pc+=1;
        title=strdup(pc);
        Tlivrable* p= (Tlivrable*) calloc(sizeof(*p),1);
        p->tn = tn;
        p->stn = stn;
        p->dn = dn;
        p->v  = v;
        p->title = title;
        p->bm = bm;
        p->em = em;

        for (v=0; data[tn][stn][dn][v]!=0 ; v++);
        data[tn][stn][dn][v] = p;
fprintf(stderr,"ADDED: %d %d %d %d\n",tn,stn,dn,v);
{int i,tn=0; fprintf(stderr,"CURR:t=%d:: ",tn); for (i=0; i<S_MAX ; i++) fprintf(stderr,"%d:%p ",i,data[tn][i][0][0]); fprintf(stderr,"\n"); }
    }
.|\n ;
%%

void prepare0()
{
int tn,stn,dn,v;
int i0,i1,i;
    for (tn=0 ; tn<T_MAX ; tn++)
    for (stn=0; stn<S_MAX; stn++) {
fprintf(stderr,"AVANT:t=%d:%d:: ",tn,stn); for (i=0; i<D_MAX ; i++)
fprintf(stderr,"%d:%p ",i,data[tn][stn][i][0]); fprintf(stderr,"\n");
        while (1) {
            for (i0=0 ; i0<D_MAX ; i0++)
                if (data[tn][stn][i0][0] == 0) break;
            for (i1=i0+1 ; i1<D_MAX ; i1++)
                if (data[tn][stn][i1][0] != 0) break;
            if (i1>=D_MAX) break;
            // shift 
            for (i=0 ; (i1+i)<D_MAX ; i++)
                for (v=0;v<V_MAX;v+=1) {
                    data[tn][stn][i0+i][v] = data[tn][stn][i1+i][v];
                    data[tn][stn][i1+i][v] = 0;
                }
        }
fprintf(stderr,"AVANT:t=%d:%d:: ",tn,stn); for (i=0; i<D_MAX ; i++)
fprintf(stderr,"%d:%p ",i,data[tn][stn][i][0]); fprintf(stderr,"\n");
    }
}
void prepare1()
{
int tn,stn,dn,v;
int i0,i1,i;
    for (tn=0 ; tn<T_MAX ; tn++) {
fprintf(stderr,"AVANT:t=%d:: ",tn,i0,i1); for (i=0; i<S_MAX ; i++) fprintf(stderr,"%d:%p ",i,data[tn][i][0][0]); fprintf(stderr,"\n");
        while (1) {
            for (i0=0 ; i0<S_MAX ; i0++)
                if (data[tn][i0][0][0] == 0) break;
            for (i1=i0+1 ; i1<S_MAX ; i1++)
                if (data[tn][i1][0][0] != 0) break;
fprintf(stderr,"%d %d %d\n",tn,i0,i1);
            if (i1>=S_MAX) break;
            // shift 
            for (i=0 ; (i1+i)<S_MAX ; i++)
                for (dn=0;dn<D_MAX;dn+=1) 
                    for (v=0;v<V_MAX;v+=1) {
                        data[tn][i0+i][dn][v] = data[tn][i1+i][dn][v];
                        data[tn][i1+i][dn][v] = 0;
                    }
        }
fprintf(stderr,"APRES:t=%d:: ",tn,i0,i1); for (i=0; i<S_MAX ; i++) fprintf(stderr,"%d:%p ",i,data[tn][i][0][0]); fprintf(stderr,"\n");
    }
}

int task_line(int tn)
{
int stn,dn,v;
int nblignes=0;
    for (stn=0 ; data[tn][stn][0][0]!=0 ; stn++)
        for (dn=0 ; data[tn][stn][dn][0]!=0 ; dn++)
            for (v=0 ; data[tn][stn][dn][v]!=0 ; v++) 
            nblignes+=1;
    return nblignes;
}

void  task_box(double pictwidth)
{
    int tn;
    for ( tn=0 ; data[tn][0][0][0]!=0 ; tn++ ) {
        const char* color= (tn%2)!=0 ? TASK_BGC1 : TASK_BGC0 ;
        printf(
            "\\put(%.1f,%.1f){\\fcolorbox{black}{%s}{\\makebox(%5.1f,%5.1f){}}}\n",
            0.0,data[tn][0][0][0]->task_y,
            color,
            pictwidth,data[tn][0][0][0]->task_dy
        );
    }
}

void  month_grid(double x, double y, double dx, double dy)
{
    int i;
    for (i=0 ;  i<=36 ; i+=1,x+=PICT_MONTHWIDTH) {
        if ( (i%3)!=0 ) continue;
        printf(
            "\\put(%5.1f,%5.1f){\\line(0,1){%5.1f}}\\put(%5.1f,%5.1f){%d}\n",
            x,y,dy-PICT_MONTHWIDTH-PICT_VSEP,
            x-2,y+dy-PICT_MONTHHEIGHT,
            i
        );
    }
}

double delivrable(
    double label_x, double box_x, double title_x,
    double y,
    int tn, int stn, int dn)
{
    double y0;
    int v;
    double label_dx = DELIVRABLE_LABELWIDTH ;
    double label_dy = DELIVRABLE_LABELHEIGHT ;
    double boxx,box_dx;
    double box_dy = DELIVRABLE_BOXHEIGHT ;
    double title_dx = DELIVRABLE_LABELWIDTH ;
    double title_dy = DELIVRABLE_TITLEHEIGHT ;
    for (v=0 ; data[tn][stn][dn][v]!=0 ; v++) {
        Tlivrable* l=data[tn][stn][dn][v] ;
        y -= DELIVRABLE_HEIGHT;
        char label[100]; sprintf(label,"D%d-%d-%d-V%c",tn,stn,dn,l->v);
        printf("% Delivrable %d %d %d\n",tn,stn,dn);
        y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_LABELHEIGHT)/2;
        printf("\\put(%.1f,%.1f)",label_x,y+y0);
        printf("{\\makebox(%.1f,%.1f)[l]{\\ganttlabelstyle{%s}}}\n",
            label_dx,label_dy,label);
        y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_BOXHEIGHT)/2;
        boxx = box_x + l->bm*PICT_MONTHWIDTH ;
        box_dx  = (l->em - l->bm) * PICT_MONTHWIDTH;
        printf("\\put(%.1f,%.1f)",boxx,y+y0);
        printf("{\\fcolorbox{black}{blue}{\\makebox(%.1f,%.1f){}}}\n",
            box_dx-2,box_dy);
        y0 = (DELIVRABLE_HEIGHT-DELIVRABLE_TITLEHEIGHT)/2;
        printf("\\put(%.1f,%.1f)",title_x,y+y0);
        printf("{\\makebox(%.1f,%.1f)[l]{\\gantttitlestyle{%s}}}\n",
            title_dx,title_dy,l->title);
        y -= DELIVRABLE_VSEP;
    }
    return y;
}

void task_delivrable(double label_x, double box_x, double title_x, int tn)
{
int stn,dn;
double y = data[tn][0][0][0]->task_y+data[tn][0][0][0]->task_dy;
    for (stn=0 ; data[tn][stn][0][0]!=0 ; stn++)
        for (dn=0 ; data[tn][stn][dn][0]!=0 ; dn++) {
            y=delivrable(label_x,box_x,title_x,y,tn,stn,dn);
    }
}

int main()
{
    int tn;
    double pictwidth, pictheight;
    double gantt_x,gantt_y;
    double gantt_dx,gantt_dy;

    double label_x,title_x;

    yylex();
    prepare0();
    prepare1();

    pictheight=0 ;
    pictheight += PICT_BOTSEP ;
    for ( tn=0 ; data[tn][0][0][0]!=0 ; tn++ );
    for ( tn=tn-1 ; tn>=0 ; tn-- ) {
        int nblines= task_line(tn);
        data[tn][0][0][0]->task_y = pictheight;
        data[tn][0][0][0]->task_line = nblines;
        data[tn][0][0][0]->task_dy = 0;
        data[tn][0][0][0]->task_dy += nblines*DELIVRABLE_HEIGHT;
        data[tn][0][0][0]->task_dy += (nblines-1)*DELIVRABLE_VSEP;
        pictheight += data[tn][0][0][0]->task_dy;
        pictheight += TASK_VSEP;
    }
    pictheight += PICT_MONTHHEIGHT;
    pictheight += PICT_TOPSEP ;
    gantt_y  = PICT_BOTSEP ;
    gantt_dy = pictheight-PICT_TOPSEP-PICT_BOTSEP ;

    pictwidth=0;
    pictwidth += PICT_LEFTSEP;
    label_x    = pictwidth;
    pictwidth += DELIVRABLE_LABELWIDTH;
    pictwidth += PICT_HSEP;
    gantt_x    = pictwidth ;
    gantt_dx   = 36*PICT_MONTHWIDTH ;
    pictwidth += gantt_dx ;
    pictwidth += PICT_HSEP;
    title_x    = pictwidth;
    pictwidth += DELIVRABLE_TITLEWIDTH;
    pictwidth += PICT_RIGHTSEP;
    
    printf("\\setlength{\\unitlength}{1.0mm}\n");
    printf("\\begin{picture}(%.1f,%.1f)\n",pictwidth,pictheight);
      task_box(pictwidth);
      month_grid(gantt_x,gantt_y,gantt_dx,gantt_dy);
      for ( tn=0 ; data[tn][0][0][0]!=0 ; tn++ ) {
        task_delivrable(label_x,gantt_x,title_x,tn);
      }
    printf("\\end{picture}\n");

    return 0;
}
