/*********************************************************************************
*   File : reset.s
*   Author : Alain Greiner
*   Date : 28/08/2006
*********************************************************************************
*   This is a minimal boot code :
*   - It initializes the Status Register (SR)
*   - It defines the stack size  and initializes the stack pointer ($29)
*   - It initializes the global pointer ($28) that is used by GCC to
*       optimize acces to the global variables.
*   - It initializes the EPC register, and jump to the main address
*********************************************************************************/

    .section .reset,"ax",@progbits

    .extern seg_stack_base
    .extern seg_data_base
    .extern main

    .globl  reset   /* makes reset an external symbol */
    .ent    reset
    .func   reset
    .align  2

reset:
    .set noreorder

/* initializes SR register */
    li      $26,    0x00000013
    mtc0    $26,    $12

/* initializes stack pointer */
    la      $29,    seg_stack_base
    addiu   $29,    $29,    0x4000

/* initializes global pointer */
    la      $28,    seg_data_base

/* jump to main in kernel mode */
    la      $26,    main
    mtc0    $26,    $14
    eret

.end    reset
.size   reset, .-reset

.set reorder

