#include <stdio.h>
#include <mwmr.h>

#define NMAX 50

/////////////////////////////////////////////
__attribute__ ((constructor)) void producer()
{
    unsigned int 	n;
    unsigned int 	buf;
    mwmr_channel_t*	mwmr;

    tty_printf("*** Starting task producer on processor %d", procid() );
    tty_printf(" at cycle %d ***\n\n", proctime() );

    unsigned int ret = mwmr_base( "router" , "seg_mwmr_in" , &mwmr );

    if ( ret )
    {
        tty_printf("\n[ERROR] in producer task :\n");
        tty_printf("          undefined <seg_mwmr_in> channel\n");
        exit();
    }
    else
    {
        tty_printf("*** &mwmr_in = %x\n\n", (unsigned int)mwmr );
    }

    // main loop : token value = departure index
    for(n = 0 ; n < NMAX ; n++) 
    { 
        buf = n;
        mwmr_write( mwmr, &buf , 1 );
        tty_printf("transmitted value : %d\n", buf);
    }

    tty_printf("\n*** Completing producer task at cycle %d ***\n", proctime());
    exit();

} // end producer()

/////////////////////////////////////////////
__attribute__ ((constructor)) void consumer()
{
    unsigned int 	n;
    unsigned int 	buf[5];
    mwmr_channel_t*	mwmr;

    tty_printf("*** Starting task consumer on processor %d", procid() );
    tty_printf(" at cycle %d ***\n\n", proctime() );

    unsigned int ret = mwmr_base( "router" , "seg_mwmr_out" , &mwmr );

    if ( ret )
    {
        tty_printf("\n[ERROR] in consumer task :\n");
        tty_printf("          undefined <seg_mwmr_out> channel\n");
        exit();
    }
    else
    {
        tty_printf("*** &mwmr_out = %x\n\n", (unsigned int)mwmr );
    }

    // main loop : display token arrival index and value
    for(n = 0 ; n < NMAX ; n = n+5 ) 
    { 
        mwmr_read( mwmr, buf , 5 );
        tty_printf("received token %d / value = %d\n", n  , buf[0]);
        tty_printf("received token %d / value = %d\n", n+1, buf[1]);
        tty_printf("received token %d / value = %d\n", n+2, buf[2]);
        tty_printf("received token %d / value = %d\n", n+3, buf[3]);
        tty_printf("received token %d / value = %d\n", n+4, buf[4]);
    }

    tty_printf("\n*** Completing consumer task at cycle %d ***\n", proctime());
    exit();

} // end consumer()

///////////////////////////////////////////
__attribute__ ((constructor)) void router()
{
    unsigned int 	buf[2];
    unsigned int 	x;
    unsigned int	tempo;
    mwmr_channel_t*	mwmr_in;
    mwmr_channel_t*	mwmr_out;
    unsigned int 	ret;
    
    tty_printf("*** Starting task router on processor %d at cycle %d ***\n\n", 
                procid(), proctime() );

    ret = mwmr_base( "router" , "seg_mwmr_in" , &mwmr_in );

    if ( ret )
    {
        tty_printf("\n[ERROR] in router task :\n");
        tty_printf("          undefined <seg_mwmr_in> channel\n");
        exit();
    }
    else
    {
        tty_printf("*** &mwmr_in = %x\n\n", (unsigned int)mwmr_in );
    }

    ret = mwmr_base( "router" , "seg_mwmr_out" , &mwmr_out );

    if ( ret )
    {
        tty_printf("\n[ERROR] in router task :\n");
        tty_printf("          undefined <seg_mwmr_out> channel\n");
        exit();
    }
    else
    {
        tty_printf("*** &mwmr_out = %x\n\n", (unsigned int)mwmr_out );
    }

    // main loop
    while(1)
    {
        mwmr_read( mwmr_in , buf , 2 );
        tempo = rand() >> 6;
        for ( x = 0 ; x < tempo ; x++ ) asm volatile ("");
        tty_printf("token value : %d / temporisation = %d\n", buf[0], tempo);
        tty_printf("token value : %d / temporisation = %d\n", buf[1], tempo);
        mwmr_write( mwmr_out, buf , 2 );
    }
}
