///////////////////////////////////////////////////////////////////////////////////
// File     : drivers.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _DRIVERS_H_
#define _DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// 	Global variables for interaction with ISRs
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned int _dma_status[];
extern volatile unsigned char _dma_busy[];

extern volatile unsigned char _ioc_status;
extern volatile unsigned char _ioc_done;
extern volatile unsigned int _ioc_lock;

extern volatile unsigned char _tty_get_buf[];
extern volatile unsigned char _tty_get_full[];

///////////////////////////////////////////////////////////////////////////////////
// Prototypes of the drivers functions.
///////////////////////////////////////////////////////////////////////////////////

unsigned int _timer_write(unsigned int global, unsigned int reg, unsigned int value);
unsigned int _timer_read(unsigned int global, unsigned int reg, unsigned int *buffer);

unsigned int _tty_write(const char *buffer, unsigned int length);
unsigned int _tty_read(char *buffer, unsigned int length);
unsigned int _tty_read_irq(char *buffer, unsigned int length);

unsigned int _ioc_write(unsigned int lba, const void *buffer, unsigned int count);
unsigned int _ioc_read(unsigned int lba, void *buffer, unsigned int count);
unsigned int _ioc_completed();

unsigned int _icu_write(unsigned int register_index, unsigned int value);
unsigned int _icu_read(unsigned int register_index, unsigned int *buffer);

unsigned int _gcd_write(unsigned int register_index, unsigned int value);
unsigned int _gcd_read(unsigned int register_index, unsigned int *buffer);

unsigned int _fb_sync_write(unsigned int offset, const void *buffer, unsigned int length);
unsigned int _fb_sync_read(unsigned int offset, const void *buffer, unsigned int length);
unsigned int _fb_write(unsigned int offset, const void *buffer, unsigned int length);
unsigned int _fb_read(unsigned int offset, const void *buffer, unsigned int length);
unsigned int _fb_completed();

#endif

