///////////////////////////////////////////////////////////////////////////////////
// File     : sys_handler.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _SYS_HANDLER_H
#define _SYS_HANDLER_H

//////////////////////////////////////////////////////////////////////////////////
// 	Syscall Vector Table (indexed by syscall index)
//////////////////////////////////////////////////////////////////////////////////

extern const void *_syscall_vector[32];

//////////////////////////////////////////////////////////////////////////////////
// Prototypes os the syscall handlers (other than peripheral drivers)
//////////////////////////////////////////////////////////////////////////////////

void		_sys_ukn();

void 		_exit();

unsigned int	_procid();

unsigned int	_proctime();

unsigned int	_procs_number( unsigned int cluster_id, 
                               unsigned int* buffer );

unsigned int	_mwmr_base( char* vspace_name,
                            char* channel_name,
                            unsigned int* buffer);

#endif
