#include <stdio.h>
#include <mwmr.h>

#define	NMAX	1000

//////////////////////////////////////////////
__attribute__ ((constructor)) void producer()
{
    unsigned int 	n;
    unsigned int 	x;
    unsigned int 	tempo;
    unsigned int 	val;
    mwmr_channel_t*	mwmr;

    tty_printf( "*** Starting task producer on processor %d at cycle %d ***\n\n", 
                procid(), proctime() );

    // get mwmr channel base address
    unsigned int ret = mwmr_base( "fifo" , "seg_mwmr" , &mwmr );

    if ( ret )
    {
        tty_printf("\n[ERROR] in fifo application / producer task :\n");
        tty_printf("          undefined mwmr channel\n");
        exit();
    }

    // main loop    
    for( n = 0 ; n < NMAX ; n++ ) 
    { 
        tempo = rand()>>6;
        val   = n;
        mwmr_write( mwmr, &val, 1 );
        for(x = 0 ; x < tempo ; x++) asm volatile ("nop");
        tty_printf("transmitted value : %d      temporisation = %d\n", val, tempo);
    }

    tty_printf("\n*** Completing producer at cycle %d ***\n", proctime());
    exit();

} // end producer()

/////////////////////////////////////////////
__attribute__ ((constructor)) void consumer()
{
    unsigned int 	n;
    unsigned int 	x;
    unsigned int 	tempo;
    unsigned int 	val;
    mwmr_channel_t*	mwmr;

    tty_printf( "*** Starting task consumer on processor %d at cycle %d ***\n\n", 
                procid(), proctime() );

    // get mwmr channel base address
    unsigned int ret = mwmr_base( "fifo" , "seg_mwmr" , &mwmr );

    if ( ret )
    {
        tty_printf("\n[ERROR] in fifo application / consumer task :\n");
        tty_printf("          undefined mwmr channel\n");
        exit();
    }

    // main loop
    for( n = 0 ; n < NMAX ; n++ ) 
    { 
        tempo = rand()>>6;
        mwmr_read( mwmr, &val, 1 );
        for(x = 0 ; x < tempo ; x++) asm volatile ("nop");
        tty_printf("received value : %d      temporisation = %d\n", val, tempo);
    }

    tty_printf("\n*** Completing consumer at cycle %d ***\n", proctime());
    exit();

} // end consumer()

