/****************************************************************************
* Definition of the base address for all virtual segments
*****************************************************************************/

/* The vsegs used in the boot phase must respect identity mapping:
   physical address = virtual address */

seg_boot_code_base  	= 0xBFC00000;	/* boot code */
seg_boot_stack_base     = 0xBFC08000;	/* boot temporary stack */ 
seg_boot_mapping_base  	= 0xBFC0C000;	/* boot mapping_info */

/* The vsegs used by the system are replicated in all virtual spaces 
   They can be identity mapping... or not */

seg_kernel_code_base    = 0x80000000;	/* system code */
seg_kernel_data_base    = 0x80010000;	/* system cacheable data */
seg_kernel_uncdata_base = 0x80020000;	/* system uncacheable data */
seg_kernel_pt_base	= 0x80030000;	/* system page table */ 

/* The peripherals base addresses are referenced by the software drivers and
   must be defined, even if the peripherals are not used in the architecture */

seg_tty_base      	= 0x90000000;   /* TTY device */
seg_timer_base    	= 0x91000000;   /* Timer device */
seg_ioc_base      	= 0x92000000;   /* Block device */
seg_dma_base      	= 0x93000000;   /* DMA device */
seg_gcd_base      	= 0x95000000;   /* GCD device */
seg_fb_base       	= 0x96000000;   /* FrameBuffer device */
seg_icu_base      	= 0x9F000000;   /* ICU device */

/*
 * Grouping sections into segments for system code and data
 */

SECTIONS
{
    . = seg_boot_code_base;
    seg_boot_code : 
    {
        *(.boot)
    }
    . = seg_kernel_code_base;
    seg_kernel_code : 
    {
        *(.giet)
        *(.text)
    }
    . = seg_kernel_data_base;
    seg_kernel_data : 
    {
        *(.rodata)
        /* . = ALIGN(4); */
        *(.rodata.*)
        /* . = ALIGN(4); */
        *(.data)
        /* . = ALIGN(4); */
        *(.lit8)
        *(.lit4)
        *(.sdata)
        /* . = ALIGN(4); */
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }
    . = seg_kernel_uncdata_base;
    seg_kernel_uncdata : 
    {
        *(.unckdata)
    }
    . = seg_kernel_pt_base;
    seg_kernel_pt : 
    {
        *(.ptab)
    }
}

