#ifndef SRL_MEMSPACE_H
#define SRL_MEMSPACE_H

/**
 * @file
 * @module{SRL}
 * @short Memory resources
 */

/**
   @internal
 */
typedef struct srl_memspace_s {
	void *buffer;
	uint32_t size;
} srl_memspace_s;

/**
   The memspace abstract type.
 */
typedef struct srl_memspace_s *srl_memspace_t;

#define SRL_MEMSPACE_INITIALIZER( b, s ) \
{\
	.buffer = b,\
		 .size = s,\
		 }

/**
   @this retrieves the base address of a memspace

   @param memsp The memspace
   @return the base address of the memspace
 */
#define SRL_MEMSPACE_ADDR(memsp) ((memsp)->buffer)

/**
   @this retrieves the size of a memspace

   @param memsp The memspace
   @return the size of the memspace
 */
#define SRL_MEMSPACE_SIZE(memsp) ((memsp)->size)

#endif
