#include "stdio.h"
#include "srl.h"

#define	NMAX	1000

//////////////////////////////////////////////
__attribute__ ((constructor)) void producer()
{
    unsigned int 	n;
    unsigned int 	x;
    unsigned int 	tempo;
    unsigned int 	val;
    // get mwmr channel base address
    srl_mwmr_t	mwmr ;
    vobj_get_vbase( "fifo" , "mwmr", MWMR, (unsigned int*)&mwmr );

    srl_log_printf( TRACE, "*** Starting task producer on processor %d at cycle %d ***\n\n", procid(), proctime() );


    if ( !mwmr )
    {
        srl_log( NONE, "\n[ERROR] in fifo application / producer task :\n");
        srl_log( NONE, "          undefined mwmr channel\n");
        exit();
    }

    // main loop    
    for( n = 0 ; n < NMAX ; n++ ) 
    { 
        tempo = rand()>>6;
        val   = n;
        srl_mwmr_write( mwmr, &val, 1 );
        for(x = 0 ; x < tempo ; x++) asm volatile ("nop");
        srl_log_printf( TRACE, "transmitted value : %d      temporisation = %d\n", val, tempo);
    }

    srl_log_printf( TRACE, "\n*** Completing producer at cycle %d ***\n", proctime());
    exit();

} // end producer()

/////////////////////////////////////////////
__attribute__ ((constructor)) void consumer()
{
    unsigned int 	n;
    unsigned int 	x;
    unsigned int 	tempo;
    unsigned int 	val;
    // get mwmr channel base address
    srl_mwmr_t	mwmr ;
    vobj_get_vbase( "fifo" , "mwmr", MWMR, (unsigned int*)&mwmr );

    srl_log_printf( TRACE,  "*** Starting task consumer on processor %d at cycle %d ***\n\n", 
                procid(), proctime() );


    if ( !mwmr )
    {
        srl_log( NONE, "\n[ERROR] in fifo application / consumer task :\n");
        srl_log( NONE, "          undefined mwmr channel\n");
        exit();
    }

    // main loop
    for( n = 0 ; n < NMAX ; n++ ) 
    { 
        tempo = rand()>>6;
        srl_mwmr_read( mwmr, &val, 1 );
        for(x = 0 ; x < tempo ; x++) asm volatile ("nop");
        srl_log_printf( TRACE, "received value : %d      temporisation = %d\n", val, tempo);
    }

    srl_log_printf( TRACE, "\n*** Completing consumer at cycle %d ***\n", proctime());
    exit();

} // end consumer()

