/*
 * This file is part of DSX, development environment for static
 * SoC applications.
 * 
 * This file is distributed under the terms of the GNU General Public
 * License.
 * 
 * Copyright (c) 2006, Nicolas Pouillon, <nipo@ssji.net>
 *     Laboratoire d'informatique de Paris 6 / ASIM, France
 * 
 *  $Id$
 */

#ifndef SRL_BARRIER_H_
#define SRL_BARRIER_H_

/**
 * @file
 * @module{SRL}
 * @short Barrier operations
 */

#include "stdio.h"
#include "srl_log.h"
#include "srl_sched_wait.h"


typedef struct srl_abstract_barrier_s
{
	unsigned int init_val;
	unsigned int count;
	
} srl_barrier_s;

# define SRL_BARRIER_INITIALIZER(n){ .init_val=(n) , .count =(n)}

typedef srl_barrier_s *srl_barrier_t;

void srl_barrier_wait( srl_barrier_t barrier );


#endif
