#ifndef SRL_PRIVATE_TYPES_H
#define SRL_PRIVATE_TYPES_H

/**
 * @file
 * @module{SRL}
 * @short Abstract types definitions
 */

#include "stdio.h"
#include "srl_barrier.h"
#include "srl_public_types.h"

#define TTY_INC 16

/**
   A numeric constant holder
 */
typedef unsigned int srl_const_t;
#define SRL_CONST_INITIALIZER(x) x

typedef void srl_task_func_t( void* );

typedef struct srl_abstract_task_s {
	srl_task_func_t *bootstrap;
	srl_task_func_t *func;
	void *args;
	void *stack;
	size_t stack_size;
	const char *name;
//	uint32_t context[CONTEXT_WSIZE];
	sint32_t wait_val;
	void *wait_addr;
	size_t tty_addr;
}srl_task_s;

#define SRL_TASK_INITIALIZER(b, f, ss, s, a, n, ttyc, ttyn)	\
	{														\
		.bootstrap = (srl_task_func_t *)b,					\
		.func = (srl_task_func_t *)f,						\
		.args = (void*)a,									\
		.stack = (void*)s,									\
		.stack_size = ss,									\
		.name = n,											\
		.tty_addr = (size_t)ttyc + (ttyn * TTY_INC),		\
	}


typedef struct srl_abstract_cpudesc_s srl_cpudesc_s;
struct srl_abstract_cpudesc_s {
	const size_t ntasks;
	const srl_task_s * const *task_list;
	size_t tty_addr;
};

#define SRL_CPUDESC_INITIALIZER(nt, tl, ttyc, ttyn)	\
	{												\
		.ntasks = nt,								\
		.task_list = tl,							\
		.tty_addr = (size_t)ttyc + (ttyn * TTY_INC),\
	}

typedef struct srl_abstract_appdesc_s srl_appdesc_s;
struct srl_abstract_appdesc_s {
	const size_t ntasks;
	srl_barrier_s *start;
	const struct srl_mwmr_s * const *mwmr;
	const srl_cpudesc_s * const *cpu;
	const srl_task_s * const *task;
	size_t tty_addr;
};

#define SRL_APPDESC_INITIALIZER(nt, cl, ml, tl, sb, ttyc, ttyn) \
	{														   \
		.ntasks = nt,										   \
		.cpu = cl,										       \
		.mwmr = ml,										       \
		.task = tl,										       \
		.start = sb,										   \
		.tty_addr = (size_t)ttyc + (ttyn * TTY_INC),						\
	}

//needed by gcc
void *memcpy(void *_dst, const void *_src, unsigned int size);
void * memset(void *dst, int data, size_t size);


/**
 * All function needed by kmain has to be tagged with in_srl_main
 * typically: srl_mwmw_sys
 */
#define in_srl_main __attribute__((section (".srl_main")))

/**
 * copy to the cache avoiding the optimisations done the compiler (volatile)
 */
#define cpu_mem_write_32(addr, data) *((volatile uint32_t*)(addr)) = data 

#define uintptr_t unsigned int

#endif
