#include "stdio.h"
#include "srl.h"

#define NMAX 200

/////////////////////////////////////////////
__attribute__ ((constructor)) void producer()
{

    unsigned int 	n;
    unsigned int 	buf;
    srl_mwmr_t	    mwmr;

    srl_log_printf( TRACE, "*** Starting task producer on processor %d", procid() );
    srl_log_printf( TRACE, " at cycle %d ***\n\n", proctime() );

    if( vobj_get_vbase( "router" , "mwmr_in", MWMR, (unsigned int*)&mwmr ) )
    {
        srl_log_printf( NONE, "\n[ERROR] in producer task :\n");
        srl_log_printf( NONE, "          undefined <mwmr_in> channel: %d\n", mwmr);
        srl_log_printf( TRACE, "*** &mwmr_in = %x\n\n", (unsigned int)mwmr );
        exit();
    }
    else
    {
        srl_log_printf( TRACE, "*** &mwmr_in = %x\n\n", (unsigned int)mwmr );
    }

    // main loop : token value = departure index
    for(n = 0 ; n < NMAX ; n++) 
    { 
        buf = n;
        srl_mwmr_write( mwmr, &buf , 1 );
        srl_log_printf( TRACE, "transmitted value : %d\n", buf);
    }

    srl_log_printf( TRACE, "\n*** Completing producer task at cycle %d ***\n", proctime());
    exit();

} // end producer()

/////////////////////////////////////////////
__attribute__ ((constructor)) void consumer()
{
    unsigned int 	n;
    unsigned int 	buf[5];
    srl_mwmr_t	mwmr;

    srl_log_printf( TRACE, "*** Starting task consumer on processor %d", procid() );
    srl_log_printf( TRACE, " at cycle %d ***\n\n", proctime() );

    if ( vobj_get_vbase( "router" , "mwmr_out", MWMR, (unsigned int*)&mwmr ) )
    {
        srl_log_printf( NONE, "\n[ERROR] in consumer task :\n");
        srl_log_printf( NONE, "          undefined <mwmr_out> channel\n");
        exit();
    }
    else
    {
        srl_log_printf( TRACE, "*** &mwmr_out = %x\n\n", (unsigned int)mwmr );
    }

    // main loop : display token arrival index and value
    for(n = 0 ; n < NMAX ; n = n+5 ) 
    { 
        srl_mwmr_read( mwmr, buf , 5 );
        srl_log_printf( TRACE, "received token %d / value = %d\n", n  , buf[0]);
        srl_log_printf( TRACE, "received token %d / value = %d\n", n+1, buf[1]);
        srl_log_printf( TRACE, "received token %d / value = %d\n", n+2, buf[2]);
        srl_log_printf( TRACE, "received token %d / value = %d\n", n+3, buf[3]);
        srl_log_printf( TRACE, "received token %d / value = %d\n", n+4, buf[4]);
    }

    srl_log_printf( TRACE, "\n*** Completing consumer task at cycle %d ***\n", proctime());
    exit();

} // end consumer()

///////////////////////////////////////////
__attribute__ ((constructor)) void router()
{
    unsigned int 	buf[2];
    unsigned int 	x;
    unsigned int	tempo;
    srl_mwmr_t  	mwmr_in ;
    srl_mwmr_t	    mwmr_out ;

    
    srl_log_printf( TRACE, "*** Starting task router on processor %d at cycle %d ***\n\n", 
                procid(), proctime() );

    if ( vobj_get_vbase( "router" , "mwmr_out", MWMR, (unsigned int*)&mwmr_out ) )
    {
        srl_log( NONE, "\n[ERROR] in router task :\n");
        srl_log( NONE, "          undefined <mwmr_in> channel\n");
        exit();
    }
    else
    {
        srl_log_printf( TRACE, "*** &mwmr_out = %x\n\n", (unsigned int)mwmr_out );
    }

    if (  vobj_get_vbase( "router" , "mwmr_in", MWMR, (unsigned int*)&mwmr_in ) )
    {
        srl_log( NONE, "\n[ERROR] in router task :\n");
        srl_log( NONE, "          undefined <mwmr_out> channel\n");
        exit();
    }
    else
    {
        srl_log_printf( TRACE, "*** &mwmr_in = %x\n\n", (unsigned int)mwmr_out );
    }

    // main loop
    while(1)
    {
        srl_mwmr_read( mwmr_in , buf , 2 );
        tempo = rand() >> 6;
        for ( x = 0 ; x < tempo ; x++ ) asm volatile ("");
        srl_log_printf( TRACE, "token value : %d / temporisation = %d\n", buf[0], tempo);
        srl_log_printf( TRACE, "token value : %d / temporisation = %d\n", buf[1], tempo);
        srl_mwmr_write( mwmr_out, buf , 2 );
    }
}
