/********************************************************************************/
/*	File : reset.S								    */
/*	Author : Alain Greiner	& Mohamed karaoui		*/
/*	Date : 03/06/2012							    */
/********************************************************************************/
/* This boot code is for a multi-cluster, multi-processor architecture,		    */
/* running one or several multi-tasks software application(s) defined in the	*/
/* the mapping_info data-structure.						                        */
/* It uses the mapping_info data structure to build the page tables.        	*/
/* Processor 0 is in charge of building all pages tables.                   	*/
/* Other processors are waiting until the mapping_info signature has been       */
/* modified by processor 0 (done while executing kernel_init code).             */
/* The entry point is 0xbfc00000, but the actual boot code starts at address	*/
/* 0xbfc00500, and a minimal boot exception handler is implemented at address	*/
/* 0xbfc0380.									                                */
/********************************************************************************/
		
#include <giet_config.h>
#include <mips32_registers.h>

#define EXCEP_ORG    		0x380
#define START_ORG    		0x500

#define OUT_MAPPING_SIGNATURE	0xBABEF00D

	.section .boot,"ax",@progbits
	.align	2
   	.set noreorder

/********************************************************/
/* reset entry point                                    */
/* (address 0xBFC00000 imposed by the hardware)         */
/********************************************************/
boot_reset:
    j	boot_start
	nop

/*******************************************************/
/* handling exceptions in the boot phase               */
/* (address 0xBFC00380 imposed by the hardware         */
/*******************************************************/
	.align	2
    .org	EXCEP_ORG
boot_excep:
    la	a0,	boot_error_string
    jal	boot_tty_puts
    nop
    mfc0	a0,	CP0_TIME
	jal	boot_tty_putw
	nop
    la	a0,	boot_lf_string
    jal	boot_tty_puts
    nop

	la	a0,	boot_epc_string
    jal	boot_tty_puts
    nop
    mfc0	a0,	CP0_EPC

	jal	boot_tty_putw
    nop
    la	a0,	boot_lf_string
    jal	boot_tty_puts
    nop

	la	a0,	boot_cr_string
    jal	boot_tty_puts
    nop
    mfc0	a0,	CP0_CR
	jal	boot_tty_putw
    nop
    la	a0,	boot_lf_string
    jal	boot_tty_puts
    nop

	la	a0,	boot_sr_string
    jal	boot_tty_puts
    nop
    mfc0	a0,	CP0_SR
	jal	boot_tty_putw
    nop
    la	a0,	boot_lf_string
    jal	boot_tty_puts
    nop

	la	a0,	boot_bar_string
    jal	boot_tty_puts
    nop
    mfc0	a0,	CP0_BAR
	jal	boot_tty_putw
    nop
    la	a0,	boot_lf_string
    jal	boot_tty_puts
    nop

	j	boot_exit
	nop

/*******************************************/
/* actual starting point for the boot code */
/*******************************************/
    .align 	2
	.org	START_ORG

boot_start:
    /* get the procid */
    mfc0	k0,	CP0_PROCID
	andi	k0,	k0,	0x3FF	/* no more than 1024 processors... */

	/* Only processor 0 does init */
	bne	k0,	zero,	boot_wait_signature
    nop

	/* temporary stack for procesor 0 : 16K */
	la	    sp,	seg_boot_stack_base
	addiu	sp,	sp,	0x4000	

    /* plat-form initialisation */
	jal	boot_init
    nop
    j app_start
    nop

boot_wait_signature:
    la  k0, seg_mapping_base
    cache   0x11,   0(k0)           /* invalidate local cache copy */
    lw  k0, 0(k0)                   /* k0 <= mapping_info[0] */
    li  k1,     OUT_MAPPING_SIGNATURE
    bne k1, k0, boot_wait_signature
    nop
	
app_start:
    /* All processors initialize PTPR / MODE */
    /* and jump to kernel_init code.        				 */

    /* get the procid */
    mfc0	s0,	CP0_PROCID
	andi	s0,	s0,	0x3FF		/* no more than 1024 processors... TOFIX*/

    /* load a PTPR */
	la	    k1,	_ptabs
    lw	    k1,	0(k1)	
    srl     k1, k1, 13
    mtc2	k1,	CP2_PTPR 		/* ptpr <= _ptabs[0]  */

	/* activates MMU */
	li	    k1,	0xF
	mtc2	k1,	CP2_MODE             	/* load MODE register */

    /* jump to kernel_init */
	la	    k0,	seg_kernel_init_base
    j       k0
    nop


boot_error_string:	.asciiz "\n[BOOT] Fatal Error at cycle"
boot_sr_string:		.asciiz "    SR   = "
boot_cr_string:		.asciiz "    CR   = "
boot_epc_string:	.asciiz "    EPC  = "
boot_bar_string:	.asciiz "    BAR  = "
boot_lf_string:		.asciiz "\n"

	.set	reorder


