/*
 * This file is part of DSX, development environment for static
 * SoC applications.
 * 
 * This file is distributed under the terms of the GNU General Public
 * License.
 * 
 * Copyright (c) 2006, Nicolas Pouillon, <nipo@ssji.net>
 *     Laboratoire d'informatique de Paris 6 / ASIM, France
 * 
 *  $Id$
 */

#ifndef SRL_LOCK_H_
#define SRL_LOCK_H_

/**
 * @file
 * @module{SRL}
 * @short Lock operations
 */

#include "srl_public_types.h"
#include "stdio.h"

typedef struct {
	unsigned int lock;
}srl_lock_t;

#define SRL_LOCK_INITIALIZER { 0 }

/**
   @this takes a lock.

   @param lock The lock object
 */
int srl_lock_lock( srl_lock_t lock );

/**
   @this releases a l-ock.

   @param lock The lock object
 */
void srl_lock_unlock( srl_lock_t lock );

/**
   @this tries to take a lock. @this returns whether the lock was
   actually taken.

   @param lock The lock object
   @return 0 if the lock was taken successfully
 */
int srl_lock_try_lock( srl_lock_t lock );

#endif
