//////////////////////////////////////////////////////////////////////////////////
// File     : stdio.h         
// Date     : 01/04/2010
// Author   : alain greiner & Joel Porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _STDIO_H
#define _STDIO_H

#include <mapping_info.h>

/* MIPS32 related functions */
unsigned int giet_procid();
unsigned int giet_proctime();

/* TTY device related functions */
unsigned int giet_tty_putc(char byte);
unsigned int giet_tty_puts(char *buf);
unsigned int giet_tty_putw(unsigned int val);
unsigned int giet_tty_getc_no_irq(char *byte);
unsigned int giet_tty_getc(char *byte);
unsigned int giet_tty_gets(char *buf, unsigned int bufsize);
unsigned int giet_tty_getw(unsigned int *val);
unsigned int giet_tty_printf(char *format,...);

/* GCD coprocessor related functions */
unsigned int giet_gcd_set_opa(unsigned int val);
unsigned int giet_gcd_set_opb(unsigned int val);
unsigned int giet_gcd_start();
unsigned int giet_gcd_get_result(unsigned int *val);
unsigned int giet_gcd_get_status(unsigned int *val);

/* Block device related functions */
unsigned int giet_ioc_read( unsigned int	lba, 
                            void*			buffer, 
                            unsigned int	count);
unsigned int giet_ioc_write(unsigned int	lba, 
                            void*			buffer, 
                            unsigned int	count);
unsigned int giet_ioc_completed();

/* Frame buffer device related functions */
unsigned int giet_fb_sync_read( unsigned int	offset, 
                                void*			buffer, 
                                unsigned int	length );
unsigned int giet_fb_sync_write(unsigned int	offset, 
                                void*			buffer, 
                                unsigned int	length );
unsigned int giet_fb_read(      unsigned int	offset, 
                                void*			buffer, 
                                unsigned int	length );
unsigned int giet_fb_write(     unsigned int	offset, 
                                void*			buffer, 
                                unsigned int	length );
unsigned int giet_fb_completed();

/* Misc */
unsigned int giet_vobj_get_vbase( char* vspace_name, 
                                  char* vobj_name,
                                  unsigned int vobj_type, 
                                  unsigned int* vobj_vaddr );
void         giet_exit();
unsigned int giet_rand();
unsigned int ctx_switch();
unsigned int giet_procnumber();

/*
 * memcpy function
 * This function is required because it can be gnerated by GCC 
 * during compilation so we must provide it.
 * Code taken from MutekH.
 */
static inline void *memcpy(void *_dst, const void *_src, unsigned int size)
{
    unsigned int *dst = _dst;
    const unsigned int *src = _src;

    /* if source and destination buffer are word-aligned,
     * then copy word-by-word */
    if (!((unsigned int)dst & 3) && !((unsigned int)src & 3))
        while (size > 3) {
            *dst++ = *src++;
            size -= 4;
        }

    unsigned char *cdst = (unsigned char*)dst;
    unsigned char *csrc = (unsigned char*)src;

    /* byte-by-byte copy */
    while (size--) {
        *cdst++ = *csrc++;
    }
    return _dst;
}

#endif

