///////////////////////////////////////////////////////////////////////////////////
// File     : boot_handler.h
// Date     : 01/04/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef     _BOOT_HANDLER_H_
#define     _BOOT_HANDLER_H_

#include    <giet_config.h>
#include    <mapping_info.h>

/////////////////////////////////////////////////////////////////////////////////////
// Page Table sizes definition
/////////////////////////////////////////////////////////////////////////////////////

#define     PT1_SIZE    8192
#define     PT2_SIZE    4096

/////////////////////////////////////////////////////////////////////////////////////
// PTE flags masks definition 
/////////////////////////////////////////////////////////////////////////////////////

#define     PTE_V       0x80000000
#define     PTE_T       0x40000000
#define     PTE_L       0x20000000
#define     PTE_R       0x10000000
#define     PTE_C       0x08000000
#define     PTE_W       0x04000000
#define     PTE_X       0x02000000
#define     PTE_U       0x01000000
#define     PTE_G       0x00800000
#define     PTE_D       0x00400000

/////////////////////////////////////////////////////////////////////////////////////
// MMU error codes definition 
/////////////////////////////////////////////////////////////////////////////////////

#define	MMU_ERR_PT1_UNMAPPED         0x001 	// Page fault on Table1 (invalid PTE) 
#define	MMU_ERR_PT2_UNMAPPED         0x002 	// Page fault on Table 2 (invalid PTE) 
#define	MMU_ERR_PRIVILEGE_VIOLATION  0x004 	// Protected access in user mode 
#define	MMU_ERR_WRITE_VIOLATION      0x008 	// Write access to a non write page 
#define	MMU_ERR_EXEC_VIOLATION       0x010 	// Exec access to a non exec page 
#define	MMU_ERR_UNDEFINED_XTN        0x020 	// Undefined external access address 
#define	MMU_ERR_PT1_ILLEGAL_ACCESS   0x040 	// Bus Error in Table1 access 
#define	MMU_ERR_PT2_ILLEGAL_ACCESS   0x080 	// Bus Error in Table2 access 
#define	MMU_ERR_CACHE_ILLEGAL_ACCESS 0x100 	// Bus Error during the cache access 

/////////////////////////////////////////////////////////////////////////////////////
// Page table structure definition
/////////////////////////////////////////////////////////////////////////////////////
typedef struct PageTable 
{
	unsigned int    pt1[PT1_SIZE];                    // PT1 (index is ix1)
	unsigned int    pt2[GIET_NB_PT2_MAX][PT2_SIZE];   // PT2s (index is 2*ix2)
} page_table_t;

/////////////////////////////////////////////////////////////////////////////////
//	Definition of the scheduler structure
/////////////////////////////////////////////////////////////////////////////////

typedef struct scheduler_s
{
    unsigned int	context[GIET_NB_TASKS_MAX][64];	  // task contexts
    unsigned int	tasks;			        	      // actual number of tasks
    unsigned int	current;			              // current task index
} scheduler_t;

///////////////////////////////////////////////////////////////////////////////////
// For retrieving base addresses defined in seg.ld file.
///////////////////////////////////////////////////////////////////////////////////

typedef struct _ld_symbol_s _ld_symbol_t;

extern _ld_symbol_t seg_icu_base;
extern _ld_symbol_t seg_timer_base;
extern _ld_symbol_t seg_tty_base;
extern _ld_symbol_t seg_gcd_base;
extern _ld_symbol_t seg_dma_base;
extern _ld_symbol_t seg_fb_base;
extern _ld_symbol_t seg_ioc_base;
extern _ld_symbol_t seg_mapping_base;
extern _ld_symbol_t seg_kernel_pt_base;

///////////////////////////////////////////////////////////////////////////////////
typedef void (*_isr_func_t)(void);

#endif 

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
