/****************************************************************************
* Definition of the base address for all virtual segments
*****************************************************************************/

/* The vsegs used in the boot phase must respect identity mapping:
   physical address = virtual address */

seg_boot_base         	= 0xBFC00000;	/* boot code */

seg_boot_stack_base     = 0xBFC08000;	/* boot temporary stack */ 

seg_mapping_base      	= 0xBFC0C000;	/* boot mapping_info */

seg_kernel_init_base    = 0x80090000;	/* system init entry */ 

seg_tty_base        	= 0x90000000;   /* TTY device: for debug purpose! */

/*
 * Grouping sections into segments for boot code and data
 */

SECTIONS
{
    /** contain both data and code sections */
    . = seg_boot_base;
    seg_boot : 
    {
        *(.boot)
        *(.text)

        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }
}
