#ifndef _CTX_HANDLER_H
#define _CTX_HANDLER_H

#include <giet_config.h>

/////////////////////////////////////////////////////////////////////////////////
//	Definition of the scheduler structure
/////////////////////////////////////////////////////////////////////////////////

typedef struct static_scheduler_s
{
    unsigned int	context[GIET_NB_TASKS_MAX][64];	  // task contexts
    unsigned int	tasks;				              // actual number of tasks
    unsigned int	current;			              // current task index
} static_scheduler_t;

/////////////////////////////////////////////////////////////////////////////////
//	Definition of the task context slots indexes
/////////////////////////////////////////////////////////////////////////////////

#define CTX_SR_ID		0
#define CTX_SP_ID		29
#define CTX_RA_ID		31

#define CTX_EPC_ID		32
#define CTX_CR_ID		33
#define CTX_PTPR_ID		35
#define CTX_MODE_ID		36

#define CTX_TTY_ID		40
#define CTX_FBDMA_ID	41
#define CTX_PTAB_ID		42
#define CTX_TASK_ID		43


//////////////////////////////////////////////////////////////////////////////////
// 	Prototype of the context switch function
//////////////////////////////////////////////////////////////////////////////////

extern void _ctx_switch();

extern static_scheduler_t _scheduler[];

#endif
