/********************************************************************************/
/*	File : giet_config.h                                                        */
/*	Author : Alain Greiner                                                      */
/*	Date : 26/03/2012                                                           */
/********************************************************************************/
/* 	Define various configuration parameters for the GIET			            */
/********************************************************************************/

#ifndef _CONFIG_H
#define _CONFIG_H

/* Debug parameters */

#define BOOT_DEBUG_VIEW		0	    /* display the mapping_info on system TTY */
#define BOOT_DEBUG_PT		0	    /* display the page tables after mapping */
#define INIT_DEBUG_CTX		0	    /* display the task contexts after mapping */
#define GIET_DEBUG_SWITCH	0	    /* Trace context switchs */


#define CONFIG_SRL_VERBOSITY TRACE 

/* hardware parameters */

#define NB_CLUSTERS 		1	    /* number of clusters */
#define CLUSTER_SPAN		0	    /* address increment between clusters */
#define NB_PROCS		    4	    /* max number of processors per cluster */
#define NB_TIMERS		    4	    /* number of timers per cluster */
#define NB_DMAS			    1	    /* total number of DMA channels */
#define NB_TTYS			    8	    /* total number of TTY terminals */

/* software parameters */

#define GIET_NB_TASKS_MAX 	4	    /* max number of tasks per processor */
#define GIET_NB_VSPACE_MAX	4	    /* max number of virtual spaces */
#define GIET_NB_PT2_MAX  	16	    /* max number of level 2 page tables per vspace */
#define GIET_TICK_VALUE	    16384   /* context switch period (number of cycles) */
#define GIET_IOMMU_ACTIVE   0		/* The IOMMU vspace is defined */

#endif

