#include <stdio.h>

#define NBLOCS 32
#define THRESHOLD 200

__attribute__((constructor)) int main(void)
{
    unsigned char buf_in[128*128];
    unsigned char buf_out[128*128];
    unsigned int i;
    unsigned int base = 0;

    while (base < 5 * NBLOCS)
    {

        giet_tty_printf("\n *** image %d *** at date = %d \n",
                base / NBLOCS, giet_proctime());

        /* Phase 1 : lecture image sur le disque et transfert vers buf_in */
        if (giet_ioc_read(base, buf_in, NBLOCS))
        {
            giet_tty_printf("echec giet_ioc_read\n");
            giet_exit();
        }
        else
        {
            giet_ioc_completed();
            giet_tty_printf("io_read  completed at date = %d \n", giet_proctime());
        }

        /* Phase 2 : transfert de buf_in vers buf_out avec seuillage */
        for (i = 0; i < 128 * 128; i++)
        {
            if (buf_in[i] > THRESHOLD)
                buf_out[i] = 255;
            else
                buf_out[i] = buf_in[i];
        }
        giet_tty_printf("image processing completed at date = %d \n", giet_proctime());

        /* Phase 3 : transfert de buf_out vers le frame buffer par dma */
        if (giet_fb_sync_write(0, buf_out, 128 * 128))
        {
            giet_tty_printf("echec giet_fb_write\n");
            giet_exit();
        }
        else
        {
            giet_tty_printf("transfer completed at date = %d \n", giet_proctime());
        }

        base = base + NBLOCS;
    }

    giet_exit();

    return 0;
}
