//////////////////////////////////////////////////////////////////////////////////
// File     : common.h         
// Date     : 20/07/2012
// Author   : mohamed karaoui
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _COMMON_H_
#define _COMMON_H_

/**
   the same as the C assert.
   Taken from Mutekh(SRL API)
 */
#define assert(expr)												    \
    do {																\
        if ( ! (expr) ) {												\
            giet_tty_printf("assertion (%s) failed on %s:%d !\n",  \
						   #expr, __FILE__, __LINE__ );					\
            __abort();												\
        }																\
    } while(0)

/**
   @this aborts the current execution.
   Taken from Mutekh(SRL API)
 */

inline void __abort();

////////////////////////////////////////////////////////////////////////////////////////
//  mempcy()
// GCC may requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void *memcpy(void *_dst, const void *_src, unsigned int size);

////////////////////////////////////////////////////////////////////////////////////////
//  memset()
// GCC may requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
inline void * memset(void *dst, int s, unsigned int count);

#endif /* _COMMON_H_ */
