#ifndef SRL_H_
#define SRL_H_

/**
   @file
   @module{SRL}
   @short SRL Api main header
 */

#include "libsrl/srl_public_types.h"
//#include "libsrl/srl_private_types.h"

#include "libsrl/srl_lock.h"
#include "libsrl/srl_mwmr.h"
#include "libsrl/srl_log.h"
#include "libsrl/srl_barrier.h"
#include "libsrl/srl_memspace.h"

#include "libsrl/srl_hw_helpers.h"

//kernel use!
//#include "libsrl/srl_mwmr_sys.h"

#define GET_MWMR(port) GET_ARG(port, VOBJ_TYPE_MWMR)
/* port, APP_NAME, TASK, #task_name, alias */
# define SRL_GET_ARG(task_name, port, type)                                                                       \
({                                                                                            \
    srl_mwmr_t  _mwmr;                                                                      \
    if( giet_vobj_get_vbase( APP_NAME , alias_##task_name.port, type, (unsigned int*)&_mwmr ) )                   \
    {                                                                                         \
        srl_log_printf( NONE, "\n[ERROR] in "#task_name" task :\n");                              \
        srl_log_printf( NONE, "          undefined port <"#port"> for channel(%s): %d\n", alias_##task_name.port,_mwmr);           \
        srl_log_printf( TRACE, "*** &"#port" = %x\n\n", (unsigned int)_mwmr );                 \
        srl_exit();                                                                     \
    }else                                                                                         \
        srl_log_printf( TRACE, "%s:%d: arg of %s for %s,from %s; &"#port" = %x\n\n", __FILE__, __LINE__, APP_NAME, #task_name,#port, (unsigned int)_mwmr ); \
    _mwmr;\
})




#endif

