#ifndef SRL_ARGS_H
#define SRL_ARGS_H



#define SRL_GET_MWMR(port)      APP_GET_ARG(port, VOBJ_TYPE_MWMR)
#define SRL_GET_BARRIER(port)   APP_GET_ARG(port, VOBJ_TYPE_BARRIER)
#define SRL_GET_LOCK(port)      APP_GET_ARG(port, VOBJ_TYPE_LOCK)
#define SRL_GET_BUFFER(port)    APP_GET_ARG(port, VOBJ_TYPE_BUFFER)


/* port, APP_NAME, TASK, #task_name, alias */
# define SRL_GET_ARG(task_name, port, type)                                                         \
({                                                                                                  \
    srl_mwmr_t  _mwmr;                                                                              \
    if( giet_vobj_get_vbase( APP_NAME , alias_##task_name.port, type, (unsigned int*)&_mwmr ) )     \
    {                                                                                               \
        srl_log_printf( NONE, "\n[ERROR] in "#task_name" task :\n");                                \
        srl_log_printf( NONE, "          undefined port <"#port"> for channel(%s): %d\n",           \
                                                                alias_##task_name.port,_mwmr);      \
        srl_log_printf( TRACE, "*** &"#port" = %x\n\n", (unsigned int)_mwmr );                      \
        srl_exit();                                                                                 \
    }else                                                                                           \
        srl_log_printf( TRACE, "%s:%d: arg of %s for %s,from %s; &"#port" = %x\n\n",                \
                            __FILE__, __LINE__, APP_NAME, #task_name,#port, (unsigned int)_mwmr );  \
    _mwmr;\
})



#endif
