//////////////////////////////////////////////////////////////////////////////////
// File     : mwmr_channel.h         
// Date     : 01/04/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _MWMR_CHANNEL_H_
#define _MWMR_CHANNEL_H_

///////////////////////////////////////////////////////////////////////////////////
//  MWMR channel structure
// The data array size is defined to obtain sizeof(mwmr_channel_t) = 4096 bytes.
// The actual size can be redefined in the mapping info data structure.
///////////////////////////////////////////////////////////////////////////////////

typedef struct mwmr_channel_s {
    unsigned int	ptr;			// index of the first valid data word
    unsigned int	ptw;			// index of the first empty slot 
    unsigned int	sts;			// number of words available
    unsigned int 	depth;			// max number of words in the channel
    unsigned int 	width;			// number of words in an item  	
    unsigned int	lock;			// exclusive access lock
    unsigned int	data[1018];		// circular buffer
} mwmr_channel_t;

//////////////////////////////////////////////////////////////////////////////
//  MWMR access functions
//////////////////////////////////////////////////////////////////////////////

void mwmr_write( mwmr_channel_t* 	mwmr, 
                 unsigned int*		buffer,
                 unsigned int 		nitems );

void mwmr_read( mwmr_channel_t* 	mwmr, 
                unsigned int*		buffer,
                unsigned int 		nitems );
#endif

