/****************************************************************************
* Definition of the base address for all virtual segments
*****************************************************************************/

/* 
The following (virtual) addresses are specific for the boot phase.
They must respect identity mapping: physical address = virtual address 
*/

seg_boot_base         	= 0xBFC00000;	/* boot code */

seg_boot_stack_base     = 0xBFC08000;	/* boot temporary stack */ 

seg_mapping_base      	= 0xBFC0C000;	/* boot mapping_info */

/* 
The following (virtual) addresse are defined and used by the kernel.
They are not constrained to respect identity mapping.  
*/

seg_kernel_init_base    = 0x80090000;	/* system init entry */ 

seg_tty_base      	    = 0x90000000;   /* TTY device */
seg_timer_base    	    = 0x91000000;   /* Timer device */
seg_ioc_base      	    = 0x92000000;   /* Block device */
seg_dma_base      	    = 0x93000000;   /* DMA device */
seg_gcd_base      	    = 0x95000000;   /* GCD device */
seg_fb_base       	    = 0x96000000;   /* FrameBuffer device */
seg_iob_base      	    = 0x9E000000;   /* IO Bridge device */
seg_icu_base      	    = 0x9F000000;   /* ICU or XICU device */

/*
Grouping sections into segments for boot code and data
*/

SECTIONS
{
    /* contain both data and code sections */
    . = seg_boot_base;
    seg_boot : 
    {
        *(.boot)
        *(.text)

        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }
}
