//////////////////////////////////////////////////////////////////////////////////
// File     : spin_lock.h         
// Date     : 01/04/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_SPIN_LOCK_H_
#define _GIET_SPIN_LOCK_H_

///////////////////////////////////////////////////////////////////////////////////
//  lock structure
// This is a simple binary lock (without waiting queue).
///////////////////////////////////////////////////////////////////////////////////

typedef struct giet_lock_s {
    char			name[32];	// lock name
    unsigned int	value; 	    // taken if value != 0
} giet_lock_t;

//////////////////////////////////////////////////////////////////////////////
//  access functions
//////////////////////////////////////////////////////////////////////////////

void lock_acquire( giet_lock_t* lock );

void lock_release( giet_lock_t* lock );

#endif

