#ifndef SRL_H_
#define SRL_H_

/**
   @file
   @module{SRL}
   @short SRL Api main header
 */

#include "libsrl/srl_public_types.h"
//#include "libsrl/srl_private_types.h"

#include "libsrl/srl_lock.h"
#include "libsrl/srl_mwmr.h"
#include "libsrl/srl_log.h"
#include "libsrl/srl_barrier.h"
#include "libsrl/srl_memspace.h"

#include "libsrl/srl_hw_helpers.h"

//kernel use!
//#include "libsrl/srl_mwmr_sys.h"

/* port, APP_NAME, TASK */
# define GET_MWMR(port)                                                                       \
({                                                                                            \
    srl_mwmr_t	_mwmr;                                                                      \
    if( vobj_get_vbase( APP_NAME , #port, MWMR, (unsigned int*)&_mwmr ) )                   \
    {                                                                                         \
        srl_log_printf( NONE, "\n[ERROR] in "TASK" task :\n");                              \
        srl_log_printf( NONE, "          undefined <"#port"> channel: %d\n", _mwmr);           \
        srl_log_printf( TRACE, "*** &"#port" = %x\n\n", (unsigned int)_mwmr );                 \
        exit();/*srl?*/                                                                     \
    }else                                                                                         \
        srl_log_printf( TRACE, "%s:%d: arg of %s for %s,from %s; &"#port" = %x\n\n", __FILE__, __LINE__, APP_NAME, TASK,#port, (unsigned int)_mwmr ); \
    _mwmr;\
})

#endif

