#include "stdio.h"
#include "mwmr_channel.h"
#include "mapping_info.h"

#define NMAX 200

/////////////////////////////////////////////
__attribute__ ((constructor)) void producer()
{

    unsigned int 	n;
    unsigned int 	buf;
    mwmr_channel_t*	mwmr;

    giet_tty_printf( "*** Starting task producer on processor %d", giet_procid() );
    giet_tty_printf( " at cycle %d ***\n\n", giet_proctime() );

    if( giet_vobj_get_vbase( "router" , 
                             "mwmr_in", 
                             VOBJ_TYPE_MWMR, 
                             (void*)&mwmr ) )
    {
        giet_tty_printf( "\n[ERROR] in producer task :\n");
        giet_tty_printf( "          undefined <mwmr_in> channel: %d\n", mwmr);
        giet_tty_printf( "*** &mwmr_in = %x\n\n", (unsigned int)mwmr );
        giet_exit();
    }

    // main loop : display token value = departure index
    for(n = 0 ; n < NMAX ; n++) 
    { 
        buf = n;
        mwmr_write( mwmr, &buf , 1 );
        giet_tty_printf( "transmitted value : %d\n", buf);
    }

    giet_tty_printf( "\n*** Completing producer task at cycle %d ***\n", giet_proctime());
    giet_exit();

} // end producer()

/////////////////////////////////////////////
__attribute__ ((constructor)) void consumer()
{
    unsigned int 	n;
    unsigned int 	buf;
    mwmr_channel_t*	mwmr;

    giet_tty_printf( "*** Starting task consumer on processor %d", giet_procid() );
    giet_tty_printf( " at cycle %d ***\n\n", giet_proctime() );

    if ( giet_vobj_get_vbase( "router" , 
                              "mwmr_out", 
                              VOBJ_TYPE_MWMR, 
                              (void*)&mwmr ) )
    {
        giet_tty_printf( "\n[ERROR] in consumer task :\n");
        giet_tty_printf( "          undefined <mwmr_out> channel\n");
        giet_exit();
    }

    // main loop : display token arrival index and value
    for(n = 0 ; n < NMAX ; n++ ) 
    { 
        mwmr_read( mwmr, &buf , 1 );
        giet_tty_printf( "received token %d / value = %d\n", n  , buf);
    }

    giet_tty_printf( "\n*** Completing consumer task at cycle %d ***\n", giet_proctime());
    giet_exit();

} // end consumer()

///////////////////////////////////////////
__attribute__ ((constructor)) void router()
{
    unsigned int 	buf[2];
    unsigned int 	x;
    unsigned int	tempo;
    mwmr_channel_t*	mwmr_in ;
    mwmr_channel_t* mwmr_out ;

    
    giet_tty_printf( "*** Starting task router on processor %d", giet_procid() ); 
    giet_tty_printf( " at cycle %d ***\n\n", giet_proctime() );

    if ( giet_vobj_get_vbase( "router" , 
                              "mwmr_out", 
                              VOBJ_TYPE_MWMR, 
                              (void*)&mwmr_out ) )
    {
        giet_tty_printf( "\n[ERROR] in router task :\n");
        giet_tty_printf( "          undefined <mwmr_in> channel\n");
        giet_exit();
    }

    if (  giet_vobj_get_vbase( "router" , 
                               "mwmr_in", 
                               VOBJ_TYPE_MWMR, 
                               (void*)&mwmr_in ) )
    {
        giet_tty_printf( "\n[ERROR] in router task :\n");
        giet_tty_printf( "          undefined <mwmr_out> channel\n");
        giet_exit();
    }

    // main loop
    while(1)
    {
        mwmr_read( mwmr_in , buf , 2 );
        tempo = giet_rand() >> 6;
        for ( x = 0 ; x < tempo ; x++ ) asm volatile ("");
        giet_tty_printf( "token value : %d / temporisation = %d\n", buf[0], tempo);
        giet_tty_printf( "token value : %d / temporisation = %d\n", buf[1], tempo);
        mwmr_write( mwmr_out, buf , 2 );
    }
}
