///////////////////////////////////////////////////////////////////////////////////
// File     : vm_handler.h
// Date     : 01/07/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef     _VM_HANDLER_H_
#define     _VM_HANDLER_H_

#include    <giet_config.h>
#include    <mapping_info.h>

/////////////////////////////////////////////////////////////////////////////////////
// Page Table sizes definition
/////////////////////////////////////////////////////////////////////////////////////

#define     PT1_SIZE    8192
#define     PT2_SIZE    4096

/////////////////////////////////////////////////////////////////////////////////////
// PTE flags masks definition 
/////////////////////////////////////////////////////////////////////////////////////

#define     PTE_V       0x80000000
#define     PTE_T       0x40000000
#define     PTE_L       0x20000000
#define     PTE_R       0x10000000
#define     PTE_C       0x08000000
#define     PTE_W       0x04000000
#define     PTE_X       0x02000000
#define     PTE_U       0x01000000
#define     PTE_G       0x00800000
#define     PTE_D       0x00400000

/////////////////////////////////////////////////////////////////////////////////////
// MMU error codes definition 
/////////////////////////////////////////////////////////////////////////////////////

#define	MMU_ERR_PT1_UNMAPPED         0x001 	// Page fault on Table1 (invalid PTE) 
#define	MMU_ERR_PT2_UNMAPPED         0x002 	// Page fault on Table 2 (invalid PTE) 
#define	MMU_ERR_PRIVILEGE_VIOLATION  0x004 	// Protected access in user mode 
#define	MMU_ERR_WRITE_VIOLATION      0x008 	// Write access to a non write page 
#define	MMU_ERR_EXEC_VIOLATION       0x010 	// Exec access to a non exec page 
#define	MMU_ERR_UNDEFINED_XTN        0x020 	// Undefined external access address 
#define	MMU_ERR_PT1_ILLEGAL_ACCESS   0x040 	// Bus Error in Table1 access 
#define	MMU_ERR_PT2_ILLEGAL_ACCESS   0x080 	// Bus Error in Table2 access 
#define	MMU_ERR_CACHE_ILLEGAL_ACCESS 0x100 	// Bus Error during the cache access 

/////////////////////////////////////////////////////////////////////////////////////
// Page table structure definition
/////////////////////////////////////////////////////////////////////////////////////
typedef struct PageTable 
{
	unsigned int    pt1[PT1_SIZE/4];                    // PT1 (index is ix1)
	unsigned int    pt2[1][PT2_SIZE/4];                 // PT2s (index is 2*ix2)
} page_table_t;


////////////////////////////////////////////////////////////////////////////////////
// Global variable
////////////////////////////////////////////////////////////////////////////////////

extern page_table_t _iommu_ptab;

////////////////////////////////////////////////////////////////////////////////////
// functions prototypes
////////////////////////////////////////////////////////////////////////////////////

void _iommu_add_pte2( unsigned int	ix1,
                      unsigned int	ix2,
                      unsigned int	ppn,
                      unsigned int	flags );

void _iommu_inval_pte2( unsigned int	ix1,
                        unsigned int	ix2 );

unsigned int _v2p_translate( page_table_t*	pt,
                             unsigned int	vpn,
                             unsigned int*	ppn,	
                             unsigned int*	flags );

#endif 

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
