#ifndef _CTX_HANDLER_H
#define _CTX_HANDLER_H

#include <giet_config.h>

/////////////////////////////////////////////////////////////////////////////////
//	Definition of the scheduler structure
/////////////////////////////////////////////////////////////////////////////////

typedef struct static_scheduler_s
{
    unsigned int	context[15][64];		// at most 15 task contexts
    unsigned int	tasks;					// actual number of tasks
    unsigned int	current;				// current task index
    unsigned int	interrupt_vector[32];	// interrupt vector
} static_scheduler_t;


/////////////////////////////////////////////////////////////////////////////////
//  "idle" task index definition
/////////////////////////////////////////////////////////////////////////////////

#define IDLE_TASK_INDEX		14

/////////////////////////////////////////////////////////////////////////////////
//	Definition of the task context slots indexes
/////////////////////////////////////////////////////////////////////////////////

#define CTX_SP_ID		29
#define CTX_RA_ID		31

#define CTX_EPC_ID		32
#define CTX_CR_ID		33
#define CTX_SR_ID		34
#define CTX_BVAR_ID		35

#define CTX_PTPR_ID		39

#define CTX_TTY_ID		40
#define CTX_FBDMA_ID	41
#define CTX_NIC_ID		42
#define CTX_TIMER_ID	43
#define CTX_PTAB_ID		44
#define CTX_LTID_ID		45
#define CTX_VSID_ID		46
#define CTX_RUN_ID		47

//////////////////////////////////////////////////////////////////////////////////
// 	Prototype of the context switch function
//////////////////////////////////////////////////////////////////////////////////

extern void _ctx_switch();
extern void _ctx_eret();
extern void _ctx_idle();

extern static_scheduler_t _scheduler[];

#endif
