
/******************************************************************************/
/* Definition of the base addresses for all vsegs used by the GIET_VM         */
/******************************************************************************/

INCLUDE giet_vsegs.ld

/******************************************************************************/
/* Grouping sections into virtual segments for system code and data           */
/******************************************************************************/

SECTIONS
{
    . = seg_kernel_code_base;
    seg_kernel_code : 
    {
        *(.giet)
        *(.text)
    }

    . = seg_kernel_data_base;
    seg_kernel_data : 
    {
        *(.iommu)
        *(.kdata)
        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }

    . = seg_kernel_uncdata_base;
    seg_kernel_uncdata : 
    {
        *(.unckdata)
    }

    . = seg_kernel_init_base;
    seg_kernel_init : 
    {
        *(.kinit)
    }
}

