///////////////////////////////////////////////////////////////////////////////////
// File     : drivers.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_SYS_DRIVERS_H_
#define _GIET_SYS_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// Timer access functions (used for both vci_multi_timer and vci_xicu)
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned char _timer_event[];

unsigned int _timer_start( unsigned int	cluster_id,
                           unsigned int	local_id, 
                           unsigned int	period );

unsigned int _timer_stop(  unsigned int	cluster_id, 
                           unsigned int local_id );


unsigned int _timer_reset_irq( unsigned int	cluster_id, 
                               unsigned int local_id );

///////////////////////////////////////////////////////////////////////////////////
// TTY access functions and variables
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned char _tty_get_buf[];
extern volatile unsigned char _tty_get_full[];
extern unsigned int           _tty_put_lock;

unsigned int _tty_write(    const char*		buffer, 
                            unsigned int	length);

unsigned int _tty_read(     char*			buffer, 
                            unsigned int	length);

unsigned int _tty_get_char( unsigned int	tty_id,
                            unsigned char*	buffer); 

///////////////////////////////////////////////////////////////////////////////////
// ICU access functions (both vci_multi_icu and vci_xicu)
///////////////////////////////////////////////////////////////////////////////////

unsigned int _icu_get_index(unsigned int	cluster_id,
                            unsigned int	proc_id, 
                            unsigned int*	buffer );

unsigned int _icu_set_mask( unsigned int	cluster_id,
							unsigned int	proc_id,
							unsigned int	mask, 
							unsigned int	is_timer );

///////////////////////////////////////////////////////////////////////////////////
// IOC access functions and variables (vci_block_device)
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned int	_ioc_status;
extern volatile unsigned int	_ioc_done;
extern unsigned int				_ioc_lock;
extern unsigned int				_ioc_iommu_ix1;
extern unsigned int				_ioc_iommu_npages; 


unsigned int _ioc_write(    unsigned int	lba, 
                            const void*		buffer, 
                            unsigned int	count);

unsigned int _ioc_read(     unsigned int	lba, 
                            void*			buffer, 
                            unsigned int	count);

unsigned int _ioc_completed();

unsigned int _ioc_get_status( unsigned int* status);

///////////////////////////////////////////////////////////////////////////////////
// Multi DMA variables			(vci_multi_dma)
///////////////////////////////////////////////////////////////////////////////////
 
extern volatile unsigned int	_dma_status[];
extern volatile unsigned int	_dma_done[];
extern unsigned int				_dma_lock[];
extern unsigned int				_dma_iommu_ix1;
extern unsigned int				_dma_iommu_npages[];

unsigned int _dma_reset_irq( unsigned int	cluster_id,
                             unsigned int	local_id );

unsigned int _dma_get_status( unsigned int	cluster_id,
                              unsigned int	local_id,
                              unsigned int*	status );

///////////////////////////////////////////////////////////////////////////////////
// Frame Buffer access functions  (vci_frame_buffer)
///////////////////////////////////////////////////////////////////////////////////
 
unsigned int _fb_sync_write(unsigned int	offset, 
                            const void*		buffer, 
                            unsigned int	length);

unsigned int _fb_sync_read( unsigned int	offset, 
                            const void*		buffer, 
                            unsigned int	length);

unsigned int _fb_write(     unsigned int	offset, 
                            const void*		buffer, 
                            unsigned int	length);

unsigned int _fb_read(      unsigned int	offset, 
                            const void*		buffer, 
                            unsigned int	length);

unsigned int _fb_completed();

///////////////////////////////////////////////////////////////////////////////////
// GCD access functions
///////////////////////////////////////////////////////////////////////////////////

unsigned int _gcd_write(    unsigned int	register_index, 
                            unsigned int	value);

unsigned int _gcd_read(     unsigned int	register_index, 
                            unsigned int*	buffer);


#endif

