/********************************************************************************/
/*	File : giet_config.h                                                        */
/*	Author : Alain Greiner                                                      */
/*	Date : 26/03/2012                                                           */
/********************************************************************************/
/* 	Define various configuration parameters for the GIET			            */
/********************************************************************************/

#ifndef _CONFIG_H
#define _CONFIG_H

/* Debug parameters */

#define BOOT_DEBUG_PERI     0			/* trace peripherals initialisation on TTY0 */
#define BOOT_DEBUG_PT		0			/* trace page tables initialisation on TTY0 */
#define BOOT_DEBUG_VOBJS	0			/* trace vobjs initialisation on TTY0 */
#define BOOT_DEBUG_SCHED 	0			/* trace schedulers initialisation on TTY0 */

#define GIET_DEBUG_INIT		0			/* trace parallel kernel initialisation on TTY0 */
#define GIET_DEBUG_SWITCH	0			/* trace context switchs on TTY0 */


#define CONFIG_SRL_VERBOSITY TRACE 

/* hardware parameters */

#define NB_CLUSTERS 		4			/* number of clusters */
#define CLUSTER_SIZE		0x40000000	/* address increment between clusters */
#define CLUSTER_IO_ID       2			/* cluster containing non replicated peripherals */
	
#define NB_PROCS_MAX	    1			/* max number of processors per cluster */
#define NB_TIMERS_MAX		0			/* max number of user timers per cluster */
#define NB_DMAS_MAX			1			/* max number of DMA channels per cluster*/
#define NB_TTYS				8			/* total number of TTY channels */
#define NB_IOCS				1			/* total number of IOC channels */
#define NB_NICS				8			/* total number of NIC channels */

/* software parameters */

#define GIET_NB_VSPACE_MAX	4			/* max number of virtual spaces */
#define GIET_TICK_VALUE	    0x4000		/* context switch period (number of cycles) */
#define GIET_IOMMU_ACTIVE   0			/* The IOMMU vspace is defined */
#define GIET_USE_XICU       1			/* Use the XICU interrupt controler */

#endif

