/****************************************************************************/
/* Definition of the base addresses for all vsegs used by the GIET_VM       */
/****************************************************************************/

/****************************************************************************/
/* The following (virtual) addresses are used by the boot code.             */
/* They must respect identity mapping, because MMU is not activated.        */
/*   (identity mapping <=> physical address == virtual address              */
/****************************************************************************/

seg_boot_code_base      = 0xBFC00000;   /* boot code */
seg_boot_stack_base     = 0xBFC08000;	/* boot temporary stack */ 
seg_mapping_base      	= 0xBFC0C000;	/* mapping_info blob */

/****************************************************************************/
/* The following (virtual) addresse are defined and used by the kernel.     */
/* They are not constrained to respect identity mapping.                    */
/****************************************************************************/

seg_kernel_code_base    = 0x80000000;	/* kernel code */
seg_kernel_data_base    = 0x80010000;	/* system cacheable data */
seg_kernel_uncdata_base = 0x80080000;	/* system uncacheable data */
seg_kernel_init_base    = 0x80090000;	/* system init entry */ 

/****************************************************************************/
/* The following (virtual) peripherals base addresses are used by both      */
/* the boot code to initialise the peripherals, and by the kernel drivers.  */
/* For sake of simplicity, they partially respect identity mapping.         */
/* As some components are replicated in all clusters (ICU, DMA), the 8 MSB  */
/* must be completed by the OS depending on the cluster index:              */
/*       virtual address = base_address + cluster_id * CLUSTER_SIZE         */
/*       ( with CLUSTER_SIZE = 4Gbytes / NB_CLUSTERS )                      */
/****************************************************************************/

seg_fbf_base       	    = 0x00D00000;   /* FrameBuffer device */

seg_icu_base      	    = 0x00F00000;   /* ICU or XICU device */
seg_ioc_base      	    = 0x00F10000;   /* Block device */
seg_tty_base      	    = 0x00F20000;   /* TTY device */
seg_dma_base      	    = 0x00F30000;   /* DMA device */
seg_tim_base    	    = 0x00F40000;   /* Timer device */
seg_gcd_base      	    = 0x00F50000;   /* GCD device */
seg_iob_base      	    = 0x00FF0000;   /* IOB device */

