/********************************************************************************/
/*	File : giet_config.h                                                        */
/*	Author : Alain Greiner                                                      */
/*	Date : 26/03/2012                                                           */
/********************************************************************************/
/* 	Define various configuration parameters for the GIET			            */
/********************************************************************************/

#ifndef _CONFIG_H
#define _CONFIG_H

/* hardware parameters */
#include "hard_config.h"


/* Debug parameters */

#define BOOT_DEBUG_PERI     0			/* trace peripherals initialisation on TTY0 */
#define BOOT_DEBUG_PT		0			/* trace page tables initialisation on TTY0 */
#define BOOT_DEBUG_VOBJS	0			/* trace vobjs initialisation on TTY0 */
#define BOOT_DEBUG_SCHED 	0			/* trace schedulers initialisation on TTY0 */

#define GIET_DEBUG_INIT		0			/* trace parallel kernel initialisation on TTY0 */
#define GIET_DEBUG_SWITCH	0			/* trace context switchs on TTY0 */

#define CONFIG_SRL_VERBOSITY TRACE 

/* software parameters */

#define GIET_NB_VSPACE_MAX	64			/* max number of virtual spaces */
#define GIET_TICK_VALUE	    0x1000		/* context switch period (number of cycles) */

#endif

