///////////////////////////////////////////////////////////////////////////////////
// File     : common.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _COMMON_H
#define _COMMON_H

#include <mapping_info.h>

///////////////////////////////////////////////////////////////////////////////////
// For retrieving base addresses defined in seg.ld file.
///////////////////////////////////////////////////////////////////////////////////

typedef struct _ld_symbol_s _ld_symbol_t;

extern _ld_symbol_t seg_iob_base;
extern _ld_symbol_t seg_nic_base;
extern _ld_symbol_t seg_icu_base;
extern _ld_symbol_t seg_tim_base;
extern _ld_symbol_t seg_tty_base;
extern _ld_symbol_t seg_gcd_base;
extern _ld_symbol_t seg_dma_base;
extern _ld_symbol_t seg_fbf_base;
extern _ld_symbol_t seg_ioc_base;
extern _ld_symbol_t seg_mapping_base;
extern _ld_symbol_t seg_kernel_pt_base;

///////////////////////////////////////////////////////////////////////////////////
// 	Prototypes of common functions
///////////////////////////////////////////////////////////////////////////////////

void				_puts(char *string);
void				_putx(unsigned int val);
void				_putd(unsigned int val);

unsigned int		_strncmp( const char* s1, 
                              const char* s2, 
                              unsigned int n );

void				_dcache_buf_invalidate( const void *buffer, 
                                            unsigned int size );

void				_dtlb_off(void);
void				_dtlb_on(void);

void				_it_mask(void);
void				_it_enable(void);

unsigned int		_get_epc(void);
unsigned int		_get_ptpr(void);
unsigned int		_get_bvar(void);
unsigned int		_get_cr(void);
unsigned int		_get_sched(void);

unsigned int		_get_context_slot( unsigned int task_id, 
                                       unsigned int slot_id );

void				_set_context_slot( unsigned int task_id, 
                                       unsigned int slot_id, 
                                       unsigned int value );

unsigned int		_get_interrupt_vector_entry(unsigned int index);

unsigned int		_get_current_task_id( void );
void				_set_current_task_id( unsigned int value );

unsigned int		_get_tasks_number(void);


void				_get_lock(unsigned int* lock);
void				_release_lock(unsigned int* lock);

mapping_cluster_t*  _get_cluster_base( mapping_header_t* header );
mapping_pseg_t*     _get_pseg_base( mapping_header_t* header );
mapping_vspace_t*   _get_vspace_base( mapping_header_t* header );
mapping_vseg_t*     _get_vseg_base( mapping_header_t* header );
mapping_vobj_t*     _get_vobj_base( mapping_header_t* header );
mapping_task_t*     _get_task_base( mapping_header_t* header );


///////////////////////////////////////////////////////////////////////////////////
// memcpy() function
// This function is likely not called directly by the GIET,
// but GCC can automatically issue call to it during compilation,
// so we must provide it. 
// Code taken from MutekH.
///////////////////////////////////////////////////////////////////////////////////
static inline void *memcpy(void *_dst, const void *_src, unsigned int size)
{
    unsigned int *dst = _dst;
    const unsigned int *src = _src;

    /* if source and destination buffer are word-aligned,
     * then copy word-by-word */
    if (!((unsigned int)dst & 3) && !((unsigned int)src & 3))
        while (size > 3) {
            *dst++ = *src++;
            size -= 4;
        }

    unsigned char *cdst = (unsigned char*)dst;
    unsigned char *csrc = (unsigned char*)src;

    /* byte-by-byte copy */
    while (size--) {
        *cdst++ = *csrc++;
    }
    return _dst;
}

#endif
