//////////////////////////////////////////////////////////////////////////////////
// File         : common.h         
// Date         : 20/07/2012
// Maintener    : mohamed karaoui
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _COMMON_H_
#define _COMMON_H_

/*
 * memcpy, memset function
 * This function is required because it can be gnerated by GCC 
 * during compilation so we must provide it.
 * Code taken from MutekH.
 */
//////////////////////////////////////////////////////////////////////////
static inline void * memcpy(void * _dst, const void * _src, unsigned int size) {
    unsigned int * dst = _dst;
    const unsigned int * src = _src;

    /* if source and destination buffer are word-aligned,
     * then copy word-by-word */
    if (!((unsigned int)dst & 3) && !((unsigned int)src & 3)) {
        while (size > 3) {
            *dst++ = *src++;
            size -= 4;
        }
    }

    unsigned char * cdst = (unsigned char *) dst;
    unsigned char * csrc = (unsigned char *) src;

    /* byte-by-byte copy */
    while (size--) {
        *cdst++ = *csrc++;
    }
    return _dst;
}


//////////////////////////////////////////////////////////
static inline void * memset(void * dst, int s, unsigned int count) {
    char * a = (char *) dst;
    while (count--) {
        *a++ = (char) s;
    }
    return dst;
}


/**
  the same as the C assert.
  Taken from Mutekh(SRL API)
  */
#define assert(expr)                                                    \
    do {                                                                \
        if ( ! (expr) ) {                                                \
            giet_tty_printf("assertion (%s) failed on %s:%d !\n",  \
#expr, __FILE__, __LINE__ );                    \
            __abort();                                                \
        }                                                                \
    } while(0)

/**
  @this aborts the current execution.
  Taken from Mutekh(SRL API)
  */
static inline void __abort() {
    asm volatile ("break 0");
    while (1);
}

#endif /* _COMMON_H_ */


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

