#ifndef _IRQ_HANDLER_H
#define _IRQ_HANDLER_H

enum 
{
    ISR_DEFAULT = 0,
    ISR_SWITCH  = 1,
    ISR_TTY     = 2,
    ISR_DMA     = 3,
    ISR_IOC     = 4,
    ISR_TIMER   = 5,
};


///////////////////////////////////////////////////////////////////////////////
// Prototypes of the Interrupt Service Routines (ISRs) supported by the GIET.
///////////////////////////////////////////////////////////////////////////////

void _irq_demux();

void _isr_default();
void _isr_ioc();
void _isr_timer(unsigned int channel);
void _isr_dma(unsigned int channel);
void _isr_tty(unsigned int channel);
void _isr_switch();

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

