///////////////////////////////////////////////////////////////////////////////////
// File     : sys_handler.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _SYS_HANDLER_H
#define _SYS_HANDLER_H

//////////////////////////////////////////////////////////////////////////////////
//     Syscall Vector Table (indexed by syscall index)
//////////////////////////////////////////////////////////////////////////////////

extern const void * _syscall_vector[32];

//////////////////////////////////////////////////////////////////////////////////
// Prototypes os the syscall handlers (other than peripheral drivers)
//////////////////////////////////////////////////////////////////////////////////

void _sys_ukn();
void _exit();
void _context_switch();
unsigned int _procid();
unsigned int _proctime();
unsigned int _procs_number(unsigned int cluster_id, unsigned int * buffer );
unsigned int _vobj_get_vbase(char * vspace_name, char * vobj_name, unsigned vobj_type, unsigned int * vobj_buffer);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

