//////////////////////////////////////////////////////////////////////////////////
// File     : stdio.h         
// Date     : 01/04/2010
// Author   : alain greiner & Joel Porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _STDIO_H
#define _STDIO_H

/* MIPS32 related functions */
unsigned int giet_procid();
unsigned int giet_proctime();

/* TTY device related functions */
unsigned int giet_tty_putc(char byte);
unsigned int giet_tty_puts(char * buf);
unsigned int giet_tty_putw(unsigned int val);
unsigned int giet_tty_getc_no_irq(char * byte);
unsigned int giet_tty_getc(char * byte);
unsigned int giet_tty_gets(char * buf, unsigned int bufsize);
unsigned int giet_tty_getw(unsigned int * val);
unsigned int giet_tty_printf(char * format,...);

/* GCD coprocessor related functions */
unsigned int giet_gcd_set_opa(unsigned int val);
unsigned int giet_gcd_set_opb(unsigned int val);
unsigned int giet_gcd_start();
unsigned int giet_gcd_get_result(unsigned int * val);
unsigned int giet_gcd_get_status(unsigned int * val);

/* Block device related functions */
unsigned int giet_ioc_read(unsigned int lba, void * buffer, unsigned int count);
unsigned int giet_ioc_write(unsigned int lba, void * buffer, unsigned int count);
unsigned int giet_ioc_completed();
unsigned int giet_ioc_block_size();

/* Frame buffer device related functions */
unsigned int giet_fb_sync_read(unsigned int offset, void * buffer, unsigned int length );
unsigned int giet_fb_sync_write(unsigned int offset, void * buffer, unsigned int length);
unsigned int giet_fb_read(unsigned int offset, void * buffer, unsigned int length);
unsigned int giet_fb_write(unsigned int offset, void * buffer, unsigned int length);
unsigned int giet_nic_write(unsigned int offset, void * buffer, unsigned int length);
unsigned int giet_nic_read(unsigned int offset, void * buffer, unsigned int length);
unsigned int giet_fb_completed();
unsigned int giet_nic_completed();

/* Misc */
unsigned int giet_vobj_get_vbase(char * vspace_name, char * vobj_name, unsigned int vobj_type, unsigned int * vobj_vaddr);
void giet_exit();
unsigned int giet_rand();
unsigned int giet_context_switch();
unsigned int giet_proc_task_id();
unsigned int giet_heap_info(unsigned int * vaddr, unsigned int * size);
unsigned int giet_global_task_id();

unsigned int giet_procnumber();

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

