////////////////////////////////////////////////////////////////////////////
// File     : malloc_private.h
// Date     : 05/03/2013
// Author   : Jean-Baptiste Bréjon
// Copyright (c) UPMC-LIP6
////////////////////////////////////////////////////////////////////////////

#ifndef _MALLOC_PRIVATE_H_
#define _MALLOC_PRIVATE_H_


typedef struct heap_linked_list {
    struct heap_linked_list * next;
    unsigned int chunk_length;
} heap_ll;

void insert_in_remote_free_list(unsigned int remote_owner_id, unsigned int block_base, unsigned int block_length);
heap_ll * pop_remote_free_list(heap_ll ** head);
heap_ll * pop_ptr(void);
void update_chunk_list(unsigned int block_base, unsigned int block_length);

#if MALLOC_SELECTED == 1 || MALLOC_SELECTED == 2
    static heap_ll * get_prev_fit_chunk(unsigned int size);
#else
    int get_prev_fit_chunk(unsigned int size);
#endif


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

