#################################################################################
#	File : reset.s
#	Author : Alain Greiner
#	Date : 15/09/2010
#################################################################################
# 	This is an improved boot code : 
#	- It initializes the Status Register (SR) 
#	- It defines the stack size  and initializes the stack pointer ($29) 
#	- It initializes the interrupt vector with two ISR addresses.
#       - It configurates the ICU : IRQ_IN[0] & IRQ_IN[1] activated.
#	- It initializes the EPC register, and jumps to the main in user mode.
#################################################################################
		
	.section .reset,"ax",@progbits

	.extern	seg_stack_base
	.extern	seg_data_base
	.extern	main
	.extern _isr_tty_get_task0
	.extern _isr_timer

	.globl  reset	 			# makes reset an external symbol 
	.ent	reset
	.align	2

reset:
       	.set noreorder

# initializes stack pointer
	la	$29,	seg_stack_base
	addiu	$29,	$29,	0x4000	

# initializes interrupt vector
        la      $26,    _interrupt_vector       # interrupt vector address
        la      $27,    _isr_timer              # 
        sw      $27,    0($26)                  # interrupt_vector[0] <= _isr_timer
        la      $27,    _isr_tty_get_task0      # 
        sw      $27,    4($26)                  # interrupt_vector[1] <= _isr_tty_get_task0

# initializes ICU
	la	$26,	seg_icu_base
	li	$27,	0x3			# IRQ_IN[0] & IRQ_IN[1] enabled
	sw	$27,	8($26)			# ICU_MASK_SET 0x3

# initializes SR register
       	li	$26,	0x0000FF13		# IRQ activation
       	mtc0	$26,	$12			

# jump to main in user mode
	la	$26,	main
	mtc0	$26,	$14
	eret

	.end	reset
	.size	reset, .-reset

	.set reorder
